/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.i18n;

import com.axelor.app.internal.AppFilter;
import com.axelor.common.StringUtils;
import com.axelor.i18n.I18nControl;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public final class I18n {
    private I18n() {
    }

    public static ResourceBundle getBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle("axelor", locale, new I18nControl());
    }

    public static ResourceBundle getBundle() {
        return I18n.getBundle(AppFilter.getLocale());
    }

    public static String get(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return message;
        }
        return I18n.getBundle().getString(message);
    }

    public static String get(String singular, String plural, int number) {
        String message = number > 1 ? I18n.get(plural) : I18n.get(singular);
        char singleQuote = '\'';
        if (message != null && message.indexOf(singleQuote) > -1) {
            StringBuilder builder = new StringBuilder();
            int length = message.length();
            boolean seen = false;
            for (int i = 0; i < length; ++i) {
                char last = message.charAt(i);
                if (seen && last != singleQuote) {
                    builder.append(singleQuote);
                }
                builder.append(last);
                seen = !seen && last == singleQuote;
            }
            if (seen) {
                builder.append(singleQuote);
            }
            message = builder.toString();
        }
        return MessageFormat.format(message, number);
    }
}

