/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.i18n;

import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.meta.db.MetaTranslation;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class I18nBundle
extends ResourceBundle {
    private final Locale locale;
    private final Map<String, String> messages = new ConcurrentHashMap<String, String>();
    private boolean loaded;

    public I18nBundle(Locale locale) {
        this.locale = locale;
    }

    @Override
    protected Object handleGetObject(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return key;
        }
        String result = this.load().get(key);
        if (StringUtils.isBlank((CharSequence)result)) {
            return key;
        }
        return result;
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.load().keySet();
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.load().keySet());
    }

    @Override
    public boolean containsKey(String key) {
        return this.handleKeySet().contains(key);
    }

    private Map<String, String> load() {
        return this.loaded ? this.messages : this.doLoad();
    }

    private synchronized Map<String, String> doLoad() {
        try {
            JPA.em();
        }
        catch (Throwable e) {
            return this.messages;
        }
        String lang = this.locale.getLanguage();
        Query<MetaTranslation> query = Query.of(MetaTranslation.class).filter("self.language = :lang AND self.message IS NOT NULL").order("id").bind("lang", lang).autoFlush(false);
        if (query.count() == 0L && lang.length() > 2) {
            query.bind("lang", lang.substring(0, 2));
        }
        long total = query.count();
        int offset = 0;
        int limit = 100;
        while ((long)offset < total) {
            for (MetaTranslation tr : query.fetch(limit, offset)) {
                this.messages.put(tr.getKey(), tr.getMessage());
            }
            offset += limit;
        }
        this.loaded = true;
        return this.messages;
    }

    public static void invalidate() {
        ResourceBundle.clearCache();
    }
}

