/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.i18n;

import com.axelor.app.AppSettings;
import com.axelor.app.internal.AppFilter;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class L10n {
    private static final String DEFAULT_DATE_FORMAT = "yyy-MM-dd";
    private static final String DEFAULT_TIME_FORMAT = "HH:mm";
    private static final String DATE_FORMAT = AppSettings.get().get("date.format", "yyy-MM-dd");
    private static final String TIME_FORMAT = "HH:mm";
    private static final String DATE_TIME_FORMAT = DATE_FORMAT + " " + "HH:mm";
    private Locale locale;

    private L10n(Locale locale) {
        this.locale = locale;
    }

    public static L10n getInstance() {
        Locale locale = AppFilter.getLocale();
        return new L10n(locale);
    }

    public static L10n getInstance(Locale locale) {
        return new L10n(locale);
    }

    public String format(Number value) {
        if (value == null) {
            return null;
        }
        NumberFormat fmt = NumberFormat.getInstance(this.locale);
        return fmt.format(value);
    }

    public String format(Number value, boolean grouping) {
        if (value == null) {
            return null;
        }
        NumberFormat fmt = NumberFormat.getInstance(this.locale);
        fmt.setGroupingUsed(grouping);
        return fmt.format(value);
    }

    public String format(LocalDate value) {
        if (value == null) {
            return null;
        }
        return DateTimeFormatter.ofPattern(DATE_FORMAT).format(value);
    }

    public String format(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return DateTimeFormatter.ofPattern(DATE_TIME_FORMAT).format(value);
    }

    public String format(ZonedDateTime value) {
        if (value == null) {
            return null;
        }
        return DateTimeFormatter.ofPattern(DATE_TIME_FORMAT).format(value);
    }
}

