/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail;

import com.axelor.mail.MailAccount;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;

public abstract class AbstractMailAccount
implements MailAccount {
    private String host;
    private String port;
    private String user;
    private String password;
    private String channel;
    private String protocol;
    private int connectionTimeout = 60000;
    private int timeout = 60000;
    private Properties properties;
    private Session session;

    public AbstractMailAccount(String protocol, String host, String port, String user, String password, String channel) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.channel = channel;
        this.protocol = protocol;
    }

    private Session init() {
        Properties props = new Properties();
        props.setProperty("mail." + this.protocol + ".connectiontimeout", "" + this.connectionTimeout);
        props.setProperty("mail." + this.protocol + ".timeout", "" + this.timeout);
        if (this.properties != null) {
            props.putAll((Map<?, ?>)this.properties);
        }
        props.setProperty("mail.store.protocol", this.protocol);
        props.setProperty("mail." + this.protocol + ".host", this.host);
        props.setProperty("mail." + this.protocol + ".port", this.port);
        if ("starttls".equalsIgnoreCase(this.channel)) {
            props.setProperty("mail." + this.protocol + ".starttls.enable", "true");
        }
        if ("ssl".equalsIgnoreCase(this.channel)) {
            props.setProperty("mail." + this.protocol + ".ssl.enable", "true");
            props.setProperty("mail." + this.protocol + ".socketFactory.port", this.port);
            props.setProperty("mail." + this.protocol + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        Authenticator authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(AbstractMailAccount.this.user, AbstractMailAccount.this.password);
            }
        };
        return Session.getInstance((Properties)props, (Authenticator)authenticator);
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = new Properties(properties);
    }

    @Override
    public Session getSession() {
        if (this.session == null) {
            this.session = this.init();
        }
        return this.session;
    }
}

