/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.ParseException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.safety.Whitelist;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public final class MailParser {
    private final MimeMessage message;
    private String text;
    private String html;
    private String summary;
    private boolean isMultiPart;
    private List<DataSource> attachments;

    public MailParser(MimeMessage message) {
        this.message = message;
        this.attachments = new ArrayList<DataSource>();
    }

    public MailParser parse() throws MessagingException, IOException {
        this.parse((MimePart)this.message);
        return this;
    }

    private List<InternetAddress> getRecipients(Message.RecipientType type) throws MessagingException {
        ArrayList<InternetAddress> result = new ArrayList<InternetAddress>();
        InternetAddress[] all = (InternetAddress[])this.message.getRecipients(type);
        if (all != null) {
            Collections.addAll(result, all);
        }
        return result;
    }

    public List<InternetAddress> getTo() throws MessagingException {
        return this.getRecipients(Message.RecipientType.TO);
    }

    public List<InternetAddress> getCc() throws MessagingException {
        return this.getRecipients(Message.RecipientType.CC);
    }

    public List<InternetAddress> getBcc() throws MessagingException {
        return this.getRecipients(Message.RecipientType.BCC);
    }

    public InternetAddress getFrom() throws MessagingException {
        InternetAddress[] all = (InternetAddress[])this.message.getFrom();
        if (all == null || all.length == 0) {
            return null;
        }
        return all[0];
    }

    public InternetAddress getReplyTo() throws MessagingException {
        InternetAddress[] all = (InternetAddress[])this.message.getReplyTo();
        if (all == null || all.length == 0) {
            return null;
        }
        return all[0];
    }

    public String getSubject() throws MessagingException {
        return this.message.getSubject();
    }

    public String getText() {
        if (this.text == null && this.html != null) {
            this.text = this.toPlainText(this.html);
        }
        return this.text;
    }

    public String getHtml() {
        return this.html;
    }

    public String getSummary() {
        if (this.summary == null && this.getText() != null && this.text.indexOf("\n") > -1) {
            String text = this.getText();
            this.summary = text.substring(0, text.indexOf("\n"));
        }
        return this.summary;
    }

    public String getSafeHtml() {
        if (this.html == null) {
            return null;
        }
        return this.sanitize(this.html);
    }

    public boolean isMultiPart() {
        return this.isMultiPart;
    }

    public boolean hasAttachments() {
        return !this.attachments.isEmpty();
    }

    public List<DataSource> getAttachments() {
        return this.attachments;
    }

    public String getHeader(String name) throws MessagingException {
        String[] all = this.message.getHeader(name);
        if (all == null || all.length == 0) {
            return null;
        }
        return all[0];
    }

    private boolean isMimeType(MimePart part, String type) throws MessagingException {
        try {
            ContentType contentType = new ContentType(part.getDataHandler().getContentType());
            return contentType.match(type);
        }
        catch (ParseException e) {
            return part.getContentType().equalsIgnoreCase(type);
        }
    }

    private void parse(MimePart part) throws MessagingException, IOException {
        boolean isAttachment;
        String disposition = part.getDisposition();
        boolean bl = isAttachment = disposition != null && disposition.contains("attachment");
        if (this.text == null && this.isMimeType(part, "text/plain") && !isAttachment) {
            this.text = (String)part.getContent();
            return;
        }
        if (this.html == null && this.isMimeType(part, "text/html") && !isAttachment) {
            this.html = (String)part.getContent();
            return;
        }
        if (this.isMimeType(part, "multipart/*")) {
            this.isMultiPart = true;
            Multipart parts = (Multipart)part.getContent();
            int count = parts.getCount();
            for (int i = 0; i < count; ++i) {
                this.parse((MimePart)((MimeBodyPart)parts.getBodyPart(i)));
            }
        } else {
            MimePartDataSource dataSource = new MimePartDataSource(part);
            this.attachments.add((DataSource)dataSource);
        }
    }

    private String toPlainText(String html) {
        Document doc = Jsoup.parse((String)html);
        FormattingVisitor formatter = new FormattingVisitor();
        NodeTraversor traversor = new NodeTraversor((NodeVisitor)formatter);
        traversor.traverse((Node)doc);
        return formatter.toString();
    }

    private String sanitize(String html) {
        return Jsoup.clean((String)html, (Whitelist)Whitelist.basicWithImages());
    }

    private static final class FormattingVisitor
    implements NodeVisitor {
        private final StringBuilder builder = new StringBuilder();

        private FormattingVisitor() {
        }

        private void newLine() {
            int n = this.builder.length();
            if (n < 2 || this.builder.charAt(n - 1) != '\n' || this.builder.charAt(n - 2) != '\n') {
                this.builder.append("\n");
            }
        }

        public void head(Node node, int depth) {
            String name;
            if (node instanceof TextNode) {
                this.builder.append(((TextNode)node).text());
                return;
            }
            switch (name = node.nodeName()) {
                case "li": {
                    this.builder.append("\n * ");
                    break;
                }
                case "dt": {
                    this.builder.append("  ");
                    break;
                }
                case "p": 
                case "div": 
                case "blockquote": 
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": 
                case "tr": {
                    this.newLine();
                }
            }
        }

        public void tail(Node node, int depth) {
            String name;
            switch (name = node.nodeName()) {
                case "a": {
                    this.builder.append(String.format(" <%s>", node.attr("href")));
                    break;
                }
                case "p": 
                case "div": 
                case "blockquote": 
                case "br": 
                case "dd": 
                case "dt": 
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": {
                    this.newLine();
                }
            }
        }

        public String toString() {
            return this.builder.toString().trim();
        }
    }
}

