/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail.db.repo;

import com.axelor.auth.db.User;
import com.axelor.db.JpaRepository;
import com.axelor.mail.db.MailFlags;
import com.axelor.mail.db.MailMessage;
import java.util.List;

public class MailFlagsRepository
extends JpaRepository<MailFlags> {
    public MailFlagsRepository() {
        super(MailFlags.class);
    }

    public MailFlags findBy(MailMessage message, User user) {
        return (MailFlags)this.all().filter("self.message = :message AND self.user = :user").bind("message", message).bind("user", user).fetchOne();
    }

    @Override
    public MailFlags save(MailFlags entity) {
        MailFlags flags = super.save(entity);
        MailMessage message = flags.getMessage();
        MailMessage root = message.getRoot();
        if (flags.getIsStarred() == Boolean.FALSE && root == null) {
            List childFlags = this.all().filter("self.message.root.id = ?", message.getId()).fetch();
            for (MailFlags child : childFlags) {
                child.setIsStarred(flags.getIsStarred());
            }
        }
        if (root == null) {
            return flags;
        }
        MailFlags rootFlags = this.findBy(root, flags.getUser());
        if (rootFlags == null) {
            rootFlags = new MailFlags();
            rootFlags.setMessage(root);
            rootFlags.setUser(flags.getUser());
            super.save(rootFlags);
        }
        rootFlags.setIsStarred(flags.getIsStarred());
        if (flags.getIsRead() != Boolean.TRUE) {
            rootFlags.setIsRead(false);
        }
        return flags;
    }
}

