/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.mail.service;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuditableRunner;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.db.mapper.Mapper;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.mail.ImapAccount;
import com.axelor.mail.MailBuilder;
import com.axelor.mail.MailConstants;
import com.axelor.mail.MailException;
import com.axelor.mail.MailParser;
import com.axelor.mail.MailReader;
import com.axelor.mail.MailSender;
import com.axelor.mail.SmtpAccount;
import com.axelor.mail.db.MailAddress;
import com.axelor.mail.db.MailFollower;
import com.axelor.mail.db.MailMessage;
import com.axelor.mail.db.repo.MailAddressRepository;
import com.axelor.mail.db.repo.MailFollowerRepository;
import com.axelor.mail.db.repo.MailMessageRepository;
import com.axelor.mail.service.MailService;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaAttachment;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaAttachmentRepository;
import com.axelor.team.db.Team;
import com.axelor.text.GroovyTemplates;
import com.axelor.text.Template;
import com.axelor.text.Templates;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.activation.DataSource;
import javax.inject.Singleton;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MailServiceImpl
implements MailService,
MailConstants {
    private MailSender sender;
    private MailReader reader;
    private boolean senderConfigured;
    private boolean readerConfigured;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private Logger log = LoggerFactory.getLogger(MailService.class);
    private static final Object FETCH_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MailSender getMailSender(MailMessage message, Model entity) {
        if (this.senderConfigured) {
            return this.sender;
        }
        try {
            MailSender mailSender = this.initSender();
            return mailSender;
        }
        finally {
            this.senderConfigured = true;
        }
    }

    private synchronized MailSender initSender() {
        AppSettings settings = AppSettings.get();
        String host = settings.get("mail.smtp.host");
        String port = settings.get("mail.smtp.port");
        String user = settings.get("mail.smtp.user");
        String pass = settings.get("mail.smtp.pass");
        String channel = settings.get("mail.smtp.channel");
        int timeout = settings.getInt("mail.smtp.timeout", 60000);
        int connectionTimeout = settings.getInt("mail.smtp.connectionTimeout", 60000);
        if (StringUtils.isBlank((CharSequence)host)) {
            return null;
        }
        SmtpAccount smtpAccount = new SmtpAccount(host, port, user, pass, channel);
        smtpAccount.setTimeout(timeout);
        smtpAccount.setConnectionTimeout(connectionTimeout);
        this.sender = new MailSender(smtpAccount);
        return this.sender;
    }

    protected MailReader getMailReader() {
        if (this.readerConfigured) {
            return this.reader;
        }
        try {
            MailReader mailReader = this.initReader();
            return mailReader;
        }
        finally {
            this.readerConfigured = true;
        }
    }

    private synchronized MailReader initReader() {
        AppSettings settings = AppSettings.get();
        String host = settings.get("mail.imap.host");
        String port = settings.get("mail.imap.port");
        String user = settings.get("mail.imap.user");
        String pass = settings.get("mail.imap.pass");
        String channel = settings.get("mail.imap.channel");
        int timeout = settings.getInt("mail.imap.timeout", 60000);
        int connectionTimeout = settings.getInt("mail.imap.connectionTimeout", 60000);
        if (StringUtils.isBlank((CharSequence)host)) {
            return null;
        }
        ImapAccount account = new ImapAccount(host, port, user, pass, channel);
        account.setTimeout(timeout);
        account.setConnectionTimeout(connectionTimeout);
        this.reader = new MailReader(account);
        return this.reader;
    }

    protected String getSubject(MailMessage message, Model entity) {
        if (message == null) {
            return null;
        }
        String subject = I18n.get(message.getSubject());
        if (subject != null && entity != null) {
            try {
                subject = Mapper.of(entity.getClass()).getNameField().get(entity).toString() + " - " + subject;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (subject == null) {
            subject = this.getSubject(message.getParent() == null ? message.getRoot() : message.getParent(), entity);
        }
        if (subject == null && entity instanceof Team) {
            subject = ((Team)entity).getName();
        }
        if (message.getParent() != null && subject != null) {
            subject = "Re: " + subject;
        }
        return subject;
    }

    protected Set<String> recipients(MailMessage message, Model entity) {
        LinkedHashSet<String> recipients = new LinkedHashSet<String>();
        MailFollowerRepository followers = Beans.get(MailFollowerRepository.class);
        if (message.getRecipients() != null) {
            for (MailAddress address : message.getRecipients()) {
                recipients.add(address.getAddress());
            }
        }
        for (MailFollower follower : followers.findAll(message)) {
            if (follower.getArchived() == Boolean.TRUE) continue;
            if (follower.getEmail() != null) {
                recipients.add(follower.getEmail().getAddress());
                continue;
            }
            if (follower.getUser() == null || follower.getUser().getEmail() == null) continue;
            recipients.add(follower.getUser().getEmail());
        }
        return Sets.filter(recipients, (Predicate)Predicates.notNull());
    }

    protected String template(MailMessage message, Model entity) throws IOException {
        String text = message.getBody().trim();
        if (text == null || !"notification".equals(message.getType()) || !text.startsWith("{") && !text.startsWith("}")) {
            return text;
        }
        MailMessageRepository messages = Beans.get(MailMessageRepository.class);
        Map<String, Object> details = messages.details(message);
        String jsonBody = details.containsKey("body") ? (String)details.get("body") : text;
        ObjectMapper mapper = Beans.get(ObjectMapper.class);
        Map data = (Map)mapper.readValue(jsonBody, (TypeReference)new TypeReference<Map<String, Object>>(){});
        data.put("entity", entity);
        Templates templates = Beans.get(GroovyTemplates.class);
        Template tmpl = templates.fromText("<ul><% for (def item : tracks) { %><% if (item.containsKey('displayValue')) { %><li><strong>${item.title}</strong>: <span>${item.oldDisplayValue}</span> &raquo; <span>${item.displayValue}</span></li><% } else { %><li><strong>${item.title}</strong>: <span>${item.oldValue}</span> &raquo; <span>${item.value}</span></li><% } %><% } %></ul>");
        return tmpl.make(data).render();
    }

    protected final Model findEntity(MailMessage message) {
        try {
            return (Model)JPA.em().find(Class.forName(message.getRelatedModel()), (Object)message.getRelatedId());
        }
        catch (ClassNotFoundException | NullPointerException e) {
            return null;
        }
    }

    @Override
    public void send(MailMessage message) throws MailException {
        MimeMessage email;
        Preconditions.checkNotNull((Object)message, (Object)"mail message can't be null");
        Model related = this.findEntity(message);
        final MailSender sender = this.getMailSender(message, related);
        if (sender == null) {
            return;
        }
        Set<String> recipients = this.recipients(message, related);
        if (recipients.isEmpty()) {
            return;
        }
        MailMessageRepository messages = Beans.get(MailMessageRepository.class);
        MailBuilder builder = sender.compose().subject(this.getSubject(message, related));
        for (String recipient : recipients) {
            builder.to(recipient);
        }
        for (MetaAttachment attachment : messages.findAttachments(message)) {
            Path filePath = MetaFiles.getPath(attachment.getMetaFile());
            File file = filePath.toFile();
            builder.attach(file.getName(), file.toString());
        }
        try {
            builder.html(this.template(message, related));
            email = builder.build(message.getMessageId());
            LinkedHashSet<String> references = new LinkedHashSet<String>();
            if (message.getParent() != null) {
                references.add(message.getParent().getMessageId());
            }
            if (message.getRoot() != null) {
                references.add(message.getRoot().getMessageId());
            }
            if (!references.isEmpty()) {
                email.setHeader("References", Joiner.on((String)" ").skipNulls().join(references));
            }
        }
        catch (IOException | MessagingException e) {
            throw new MailException(e);
        }
        this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                MailServiceImpl.this.send(sender, email);
                return true;
            }
        });
    }

    @Transactional(rollbackOn={Exception.class})
    protected void send(final MailSender sender, final MimeMessage email) throws Exception {
        AuditableRunner runner = Beans.get(AuditableRunner.class);
        Callable<Boolean> job = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                sender.send((Message)email);
                MailServiceImpl.this.messageSent(email);
                return true;
            }
        };
        runner.run(job);
    }

    protected void messageSent(MimeMessage email) {
    }

    protected MailMessage messageReceived(MimeMessage email) throws MessagingException, IOException {
        this.log.info("new email recieved: {}", (Object)email.getMessageID());
        MailParser parser = new MailParser(email).parse();
        String messageId = email.getMessageID();
        HashSet<String> parentIds = new HashSet<String>();
        String parentId = parser.getHeader("In-Reply-To");
        if (parentId != null) {
            parentIds.add(parentId);
        }
        if ((parentId = parser.getHeader("X-References")) != null) {
            parentIds.addAll(Splitter.on((String)" ").trimResults().omitEmptyStrings().splitToList((CharSequence)parentId));
        }
        if ((parentId = parser.getHeader("References")) != null) {
            parentIds.addAll(Splitter.on((String)" ").trimResults().omitEmptyStrings().splitToList((CharSequence)parentId));
        }
        if (parentIds.isEmpty()) {
            this.log.info("it's not a reply, ignoring...");
            return null;
        }
        UserRepository users = Beans.get(UserRepository.class);
        MailAddressRepository emails = Beans.get(MailAddressRepository.class);
        MailMessageRepository messages = Beans.get(MailMessageRepository.class);
        MailMessage parent = (MailMessage)messages.all().filter("self.messageId in (:ids)").bind("ids", parentIds).fetchOne();
        if (parent == null) {
            this.log.info("parent message doesn't exist, ignoring...");
            return null;
        }
        MailMessage existing = (MailMessage)messages.all().filter("self.messageId = ?", messageId).fetchOne();
        if (existing != null) {
            this.log.info("message already imported, ignoring...");
            return null;
        }
        MailMessage message = new MailMessage();
        String content = parser.getHtml() == null ? parser.getText() : parser.getHtml();
        String summary = parser.getSummary();
        message.setSubject(parser.getSubject());
        message.setBody(content);
        message.setSummary(summary);
        message.setType("email");
        message.setRelatedModel(parent.getRelatedModel());
        message.setRelatedId(parent.getRelatedId());
        message.setRelatedName(parent.getRelatedName());
        InternetAddress from = parser.getFrom();
        MailAddress address = emails.findOrCreate(from.getAddress(), from.getPersonal());
        User author = users.findByEmail(from.getAddress());
        message.setAuthor(author);
        message.setFrom(address);
        messages.save(message);
        this.log.info("message from: {}", (Object)from.getAddress());
        MetaAttachmentRepository attachments = Beans.get(MetaAttachmentRepository.class);
        MetaFiles files = Beans.get(MetaFiles.class);
        for (DataSource ds : parser.getAttachments()) {
            this.log.info("attaching file: {}", (Object)ds.getName());
            MetaFile file = files.upload(ds.getInputStream(), ds.getName());
            MetaAttachment attachment = files.attach(file, message);
            attachments.save(attachment);
        }
        return message;
    }

    @Transactional(rollbackOn={Exception.class})
    protected void fetch(MailReader reader) throws MessagingException, IOException {
        Store store = reader.getStore();
        Folder inbox = store.getFolder("INBOX");
        MailMessageRepository repo = Beans.get(MailMessageRepository.class);
        this.log.debug("Fetching new emails from: {}", (Object)store.getURLName());
        inbox.open(2);
        FlagTerm unseen = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
        FlagTerm flagged = new FlagTerm(new Flags("fetched"), false);
        AndTerm term = new AndTerm((SearchTerm)unseen, (SearchTerm)flagged);
        FetchProfile profile = new FetchProfile();
        Message[] messages = inbox.search((SearchTerm)term);
        profile.add(FetchProfile.Item.ENVELOPE);
        inbox.fetch(messages, profile);
        int count = 0;
        for (Message message : messages) {
            if (!(message instanceof MimeMessage)) continue;
            MailMessage entity = this.messageReceived((MimeMessage)message);
            if (entity != null) {
                repo.save(entity);
                ++count;
                continue;
            }
            message.setFlag(Flags.Flag.SEEN, false);
            message.setFlags(new Flags("fetched"), true);
        }
        this.log.debug("Fetched {} emails from: {}", (Object)count, (Object)store.getURLName());
        inbox.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetch() throws MailException {
        Object object = FETCH_LOCK;
        synchronized (object) {
            MailReader reader = this.getMailReader();
            if (reader == null) {
                return;
            }
            AuditableRunner runner = Beans.get(AuditableRunner.class);
            runner.run(() -> {
                try {
                    this.fetch(reader);
                }
                catch (Exception e) {
                    this.log.error("Unable to fetch messages", (Throwable)e);
                }
            });
        }
    }

    @Override
    public Model resolve(String email) {
        UserRepository users = Beans.get(UserRepository.class);
        return users.all().filter("self.email is not null and self.email = ?", email).fetchOne();
    }

    @Override
    public List<InternetAddress> findEmails(String matching, List<String> selected, int maxResult) {
        ArrayList<String> where = new ArrayList<String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        where.add("self.email is not null");
        if (!StringUtils.isBlank((CharSequence)matching)) {
            where.add("(LOWER(self.email) like LOWER(:email) OR LOWER(self.name) like LOWER(:email))");
            params.put("email", "%" + matching + "%");
        }
        if (selected != null && !selected.isEmpty()) {
            where.add("self.email not in (:selected)");
            params.put("selected", selected);
        }
        String filter = Joiner.on((String)" AND ").join(where);
        Query<User> q = Query.of(User.class);
        if (!StringUtils.isBlank((CharSequence)filter)) {
            q.filter(filter);
            q.bind(params);
        }
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
        for (User user : q.fetch(maxResult)) {
            try {
                InternetAddress item = new InternetAddress(user.getEmail(), user.getName());
                addresses.add(item);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return addresses;
    }
}

