/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta;

import com.axelor.event.Event;
import com.axelor.events.PostAction;
import com.axelor.events.PreAction;
import com.axelor.meta.ActionHandler;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import javax.inject.Inject;

public class ActionExecutor {
    private final Event<PreAction> preActionEvent;
    private final Event<PostAction> postActionEvent;

    @Inject
    ActionExecutor(Event<PreAction> preActionEvent, Event<PostAction> postActionEvent) {
        this.preActionEvent = preActionEvent;
        this.postActionEvent = postActionEvent;
    }

    public ActionHandler newActionHandler(ActionRequest request) {
        return new ActionHandler(request, this.preActionEvent, this.postActionEvent);
    }

    public ActionResponse execute(ActionRequest request) {
        return this.newActionHandler(request).execute();
    }

    Event<PreAction> getPreActionEvent() {
        return this.preActionEvent;
    }

    Event<PostAction> getPostActionEvent() {
        return this.postActionEvent;
    }
}

