/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta;

import com.axelor.auth.db.Role;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.axelor.db.JpaSecurity;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaPermission;
import com.axelor.meta.db.MetaPermissionRule;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
public class MetaPermissions {
    private static final String CAN_READ = "read";
    private static final String CAN_WRITE = "write";
    private static final String CAN_EXPORT = "export";

    private MetaPermission find(Set<MetaPermission> permissions, String object, String field) {
        if (permissions == null) {
            return null;
        }
        for (MetaPermission perm : permissions) {
            if (!object.equals(perm.getObject()) || perm.getActive() != Boolean.TRUE || perm.getRules() == null) continue;
            for (MetaPermissionRule rule : perm.getRules()) {
                if (!field.equals(rule.getField())) continue;
                return perm;
            }
        }
        return null;
    }

    private MetaPermission find(User user, String object, String field) {
        MetaPermission permission;
        block5: {
            Role role;
            Iterator<Role> iterator;
            if (user == null) {
                return null;
            }
            permission = this.find(user.getMetaPermissions(), object, field);
            if (permission == null && user.getGroup() != null) {
                permission = this.find(user.getGroup().getMetaPermissions(), object, field);
            }
            if (permission == null && user.getRoles() != null) {
                iterator = user.getRoles().iterator();
                while (iterator.hasNext() && (permission = this.find((role = iterator.next()).getMetaPermissions(), object, field)) == null) {
                }
            }
            if (permission != null || user.getGroup() == null || user.getGroup().getRoles() == null) break block5;
            iterator = user.getGroup().getRoles().iterator();
            while (iterator.hasNext() && (permission = this.find((role = iterator.next()).getMetaPermissions(), object, field)) == null) {
            }
        }
        return permission;
    }

    public MetaPermissionRule findRule(User user, String object, String field) {
        MetaPermission permission = this.find(user, object, field);
        if (permission == null) {
            return null;
        }
        for (MetaPermissionRule rule : permission.getRules()) {
            if (!field.equals(rule.getField())) continue;
            return rule;
        }
        return null;
    }

    public boolean isCollectionReadable(User user, String object, String field) {
        Class<?> klass;
        if (StringUtils.isBlank((CharSequence)object)) {
            return true;
        }
        try {
            klass = Class.forName(object);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        Mapper mapper = Mapper.of(klass);
        Property property = mapper.getProperty(field);
        return property == null || !property.isCollection() || Beans.get(JpaSecurity.class).isPermitted(JpaSecurity.CAN_READ, property.getTarget().asSubclass(Model.class), new Long[0]);
    }

    private boolean can(User user, String object, String field, String access) {
        MetaPermissionRule rule = this.findRule(user, object, field);
        if (rule == null) {
            return true;
        }
        switch (access) {
            case "read": {
                if (rule.getCanRead() != Boolean.TRUE) break;
                return true;
            }
            case "write": {
                if (rule.getCanWrite() != Boolean.TRUE) break;
                return true;
            }
            case "export": {
                if (rule.getCanExport() != Boolean.TRUE) break;
                return true;
            }
        }
        return false;
    }

    public boolean canRead(User user, String object, String field) {
        return this.can(user, object, field, CAN_READ);
    }

    public boolean canWrite(User user, String object, String field) {
        return this.can(user, object, field, CAN_EXPORT);
    }

    public boolean canExport(User user, String object, String field) {
        return this.can(user, object, field, CAN_EXPORT);
    }
}

