/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.Inflector;
import com.axelor.common.StringUtils;
import com.axelor.db.JpaSecurity;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.db.ValueEnum;
import com.axelor.db.annotations.Widget;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaPermissions;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaJsonModel;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.meta.db.MetaPermissionRule;
import com.axelor.meta.db.MetaSelectItem;
import com.axelor.meta.db.repo.MetaJsonModelRepository;
import com.axelor.meta.loader.ModuleManager;
import com.axelor.meta.loader.XMLViews;
import com.axelor.meta.schema.ObjectViews;
import com.axelor.meta.schema.actions.Action;
import com.axelor.meta.schema.views.Selection;
import com.axelor.script.CompositeScriptHelper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaStore {
    private static final Logger log = LoggerFactory.getLogger(MetaStore.class);
    private static final Cache<String, Action> ACTIONS = CacheBuilder.newBuilder().maximumSize(1000L).weakValues().build();

    private MetaStore() {
    }

    static void resister(ObjectViews views) {
        try {
            for (Action item : views.getActions()) {
                ACTIONS.put((Object)item.getName(), (Object)item);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static Action getAction(String name) {
        Action action = (Action)ACTIONS.getIfPresent((Object)name);
        if (action == null && (action = XMLViews.findAction(name)) != null) {
            ACTIONS.put((Object)name, (Object)action);
        }
        if (action == null) {
            return null;
        }
        String module = action.getModuleToCheck();
        if (StringUtils.isBlank((CharSequence)module) || ModuleManager.isInstalled(module)) {
            return action;
        }
        return null;
    }

    public static Map<String, Object> getPermissions(Class<?> model) {
        User user = AuthUtils.getUser();
        if (user == null || AuthUtils.isAdmin(user) || !Model.class.isAssignableFrom(model)) {
            return null;
        }
        Class<?> klass = model;
        HashMap<String, Object> map = new HashMap<String, Object>();
        JpaSecurity security = Beans.get(JpaSecurity.class);
        map.put("read", security.isPermitted(JpaSecurity.AccessType.READ, klass, new Long[0]));
        map.put("write", security.isPermitted(JpaSecurity.AccessType.WRITE, klass, new Long[0]));
        map.put("create", security.isPermitted(JpaSecurity.AccessType.CREATE, klass, new Long[0]));
        map.put("remove", security.isPermitted(JpaSecurity.AccessType.REMOVE, klass, new Long[0]));
        map.put("export", security.isPermitted(JpaSecurity.AccessType.EXPORT, klass, new Long[0]));
        return map;
    }

    private static Property findField(Mapper mapper, String name) {
        Mapper current = mapper;
        Iterator iter = Splitter.on((String)".").split((CharSequence)name).iterator();
        Property property = current.getProperty((String)iter.next());
        if (property == null || property.isJson() && iter.hasNext()) {
            return null;
        }
        while (property != null && property.getTarget() != null && iter.hasNext()) {
            current = Mapper.of(property.getTarget());
            property = current.getProperty((String)iter.next());
        }
        return property;
    }

    public static Map<String, Object> findFields(Class<?> modelClass, Collection<String> names) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Mapper mapper = Mapper.of(modelClass);
        LinkedHashMap<String, Property> fieldsMap = new LinkedHashMap<String, Property>();
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        boolean massUpdate = false;
        Object bean = null;
        try {
            bean = modelClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String name : names) {
            Property property = MetaStore.findField(mapper, name);
            if (property == null) continue;
            Map<String, Object> map = property.toMap();
            map.put("name", name);
            if (property.getSelection() != null && !"".equals(property.getSelection().trim())) {
                map.put("selection", property.getSelection());
                map.put("selectionList", MetaStore.getSelectionList(property.getSelection()));
            }
            if (property.isEnum()) {
                map.put("selectionList", MetaStore.getSelectionList(property.getEnumType()));
            }
            if (property.getTarget() != null) {
                map.put("perms", MetaStore.getPermissions(property.getTarget()));
            }
            if (property.isMassUpdate() && !name.contains(".")) {
                massUpdate = true;
            }
            if (!property.isTransient() && !property.isVirtual()) {
                Object defaultValue;
                Object obj = null;
                if (name.contains(".")) {
                    try {
                        obj = property.getEntity().newInstance();
                    }
                    catch (Exception exception) {}
                } else {
                    obj = bean;
                }
                if (obj != null && (defaultValue = property.get(obj)) != null) {
                    map.put("defaultValue", defaultValue);
                }
            }
            if (name.contains(".")) {
                map.put("readonly", true);
            }
            fieldsMap.put(name, property);
            fields.add(map);
        }
        Map<String, Object> perms = MetaStore.getPermissions(modelClass);
        if (massUpdate) {
            if (perms == null) {
                perms = new HashMap<String, Object>();
            }
            perms.put("massUpdate", massUpdate);
        }
        HashMap<String, Map<String, Object>> jsonFields = new HashMap<String, Map<String, Object>>();
        for (String name : names) {
            HashMap<String, String> attrs;
            Map jsonField;
            if (fieldsMap.containsKey(name) || name.indexOf(46) == -1) continue;
            String first = name.substring(0, name.indexOf(46));
            String field = name.substring(name.indexOf(46) + 1);
            Property property = MetaStore.findField(mapper, first);
            if (property == null || !property.isJson()) continue;
            if (!jsonFields.containsKey(first)) {
                jsonFields.put(first, MetaStore.findJsonFields(modelClass.getName(), first));
            }
            if ((jsonField = (Map)jsonFields.get(first)) == null || !jsonField.containsKey(field) || (attrs = new HashMap<String, String>((Map)jsonField.get(field))) == null) continue;
            attrs.put("name", name);
            fields.add(attrs);
        }
        data.put("perms", perms);
        data.put("fields", fields);
        return data;
    }

    private static Map<String, Object> checkPermissions(Map<String, Object> fields, String object, String jsonField) {
        User user = AuthUtils.getUser();
        MetaPermissions perms = Beans.get(MetaPermissions.class);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> item : fields.entrySet()) {
            String name = jsonField == null ? item.getKey() : jsonField + "." + item.getKey();
            MetaPermissionRule rule = perms.findRule(user, object, name);
            Map attrs = (Map)item.getValue();
            if (rule == null) {
                result.put(item.getKey(), attrs);
                continue;
            }
            if (rule.getCanRead() != Boolean.TRUE) continue;
            if (!attrs.containsKey("readonlyIf") && rule.getReadonlyIf() != null) {
                attrs.put("readonlyIf", rule.getReadonlyIf());
            }
            if (!attrs.containsKey("hideIf") && rule.getHideIf() != null) {
                attrs.put("hideIf", rule.getHideIf());
            }
            if (rule.getCanWrite() != Boolean.TRUE) {
                attrs.put("readonly", true);
                if (StringUtils.isBlank((CharSequence)rule.getReadonlyIf())) {
                    attrs.remove("readonlyIf");
                }
            }
            result.put(item.getKey(), attrs);
        }
        return result;
    }

    public static Map<String, Object> findJsonFields(String modelName, String fieldName) {
        try {
            if (!Mapper.of(Class.forName(modelName)).getProperty(fieldName).isJson()) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        List<MetaJsonField> fields = Query.of(MetaJsonField.class).filter("self.model = :model AND self.modelField = :field").bind("model", modelName).bind("field", fieldName).order("sequence").order("id").fetch();
        Map<String, Object> result = MetaStore.updateJsonFields(fields, fieldName);
        return MetaStore.checkPermissions(result, modelName, fieldName);
    }

    public static Map<String, Object> findJsonFields(String jsonModel) {
        MetaJsonModelRepository forms = Beans.get(MetaJsonModelRepository.class);
        MetaJsonModel found = forms.findByName(jsonModel);
        if (found == null) {
            return null;
        }
        Map<String, Object> result = MetaStore.updateJsonFields(found.getFields(), "attrs");
        return MetaStore.checkPermissions(result, jsonModel, null);
    }

    private static Map<String, Object> updateJsonFields(List<MetaJsonField> records, String fieldName) {
        Field[] declaredFields = MetaJsonField.class.getDeclaredFields();
        Mapper mapper = Mapper.of(MetaJsonField.class);
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        ArrayList<MetaJsonField> jsonFields = new ArrayList<MetaJsonField>(records);
        User user = AuthUtils.getUser();
        CompositeScriptHelper scriptHelper = null;
        jsonFields.sort((a, b) -> {
            int x = a.getSequence() == null ? 0 : a.getSequence();
            int y = b.getSequence() == null ? 0 : b.getSequence();
            return Integer.compare(x, y);
        });
        for (MetaJsonField record : jsonFields) {
            int max;
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            String name = record.getName();
            if (record.getRoles() != null && !record.getRoles().isEmpty()) {
                HashSet roles = new HashSet();
                if (user.getRoles() != null) {
                    roles.addAll(user.getRoles());
                }
                if (user.getGroup() != null && user.getGroup().getRoles() != null) {
                    roles.addAll(user.getGroup().getRoles());
                }
                if (Collections.disjoint(roles, record.getRoles())) continue;
            }
            if (StringUtils.notBlank((CharSequence)record.getIncludeIf())) {
                if (scriptHelper == null) {
                    scriptHelper = new CompositeScriptHelper(null);
                }
                if (scriptHelper == null || !scriptHelper.test(record.getIncludeIf())) continue;
            }
            for (Field field : declaredFields) {
                Object value;
                Property prop = mapper.getProperty(field.getName());
                if (prop == null || prop.isPrimary() || prop.isReference() || prop.isCollection() || (value = prop.get(record)) == null || value == Boolean.FALSE) continue;
                attrs.put(prop.getName(), value);
            }
            String title = record.getTitle();
            attrs.put("title", I18n.get(title));
            if (StringUtils.isBlank((CharSequence)title)) {
                String last = name.substring(name.lastIndexOf(46) + 1);
                title = I18n.get(Inflector.getInstance().humanize(last));
                attrs.put("autoTitle", title);
            }
            String type = record.getType() == null ? "" : record.getType();
            int min = record.getMinSize() == null ? 0 : record.getMinSize();
            int n = max = record.getMaxSize() == null ? 0 : record.getMaxSize();
            if (max <= min) {
                attrs.remove("maxSize");
            }
            if (min == 0 && max == 0 || type.matches("date|time|datetime|boolean")) {
                attrs.remove("maxSize");
                attrs.remove("minSize");
            }
            if ("ref-select".equalsIgnoreCase(record.getType()) || "ref-select".equalsIgnoreCase(record.getWidget()) || "RefSelect".equalsIgnoreCase(record.getWidget())) {
                attrs.put("widget", "json-ref-select");
            }
            if (!StringUtils.isBlank((CharSequence)record.getTargetModel())) {
                attrs.put("target", record.getTargetModel());
                attrs.remove("targetModel");
                try {
                    Property nameField = Mapper.of(Class.forName(record.getTargetModel())).getNameField();
                    if (nameField != null) {
                        attrs.put("targetName", nameField.getName());
                    }
                }
                catch (ClassNotFoundException nameField) {
                    // empty catch block
                }
            }
            if (type.startsWith("json-")) {
                type = type.substring(5);
                attrs.put("type", type);
                attrs.put("target", MetaJsonRecord.class.getName());
                if (record.getTargetJsonModel() != null) {
                    MetaJsonModel targetModel = record.getTargetJsonModel();
                    String domain = String.format("self.jsonModel = '%s'", targetModel.getName());
                    if (!StringUtils.isBlank((CharSequence)record.getDomain())) {
                        domain = String.format("(%s) AND (%s)", domain, record.getDomain());
                    }
                    attrs.put("domain", domain);
                    attrs.put("gridView", targetModel.getGridView().getName());
                    attrs.put("formView", targetModel.getFormView().getName());
                    attrs.put("targetName", "name");
                    attrs.put("jsonTarget", targetModel.getName());
                }
            }
            if (StringUtils.notBlank((CharSequence)record.getSelection())) {
                attrs.put("selectionList", MetaStore.getSelectionList(record.getSelection()));
            }
            if (StringUtils.notBlank((CharSequence)record.getEnumType())) {
                try {
                    attrs.put("selectionList", MetaStore.getSelectionList(Class.forName(record.getEnumType())));
                }
                catch (ClassNotFoundException e) {
                    log.error("No such enum type found: {}", (Object)record.getEnumType());
                }
            }
            attrs.put("jsonField", fieldName);
            attrs.put("jsonPath", record.getName());
            if (type.matches("integer|decimal|boolean")) {
                attrs.put("jsonType", type);
            }
            fields.put(record.getName(), attrs);
        }
        return fields;
    }

    public static List<Selection.Option> getSelectionList(Class<?> enumType) {
        if (enumType == null || !enumType.isEnum()) {
            return null;
        }
        ArrayList<Selection.Option> all = new ArrayList<Selection.Option>();
        for (Enum item : enumType.asSubclass(Enum.class).getEnumConstants()) {
            Object value;
            Selection.Option option = new Selection.Option();
            String name = item.name();
            option.setValue(name);
            if (item instanceof ValueEnum && !Objects.equal((Object)name, value = ((ValueEnum)((Object)item)).getValue())) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("value", value);
                option.setData(data);
            }
            try {
                Field field = enumType.getDeclaredField(name);
                Widget widget = field.getAnnotation(Widget.class);
                if (StringUtils.notBlank((CharSequence)widget.title())) {
                    option.setTitle(widget.title());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (option.getTitle() == null) {
                option.setTitle(Inflector.getInstance().humanize(name));
            }
            all.add(option);
        }
        return all;
    }

    public static List<Selection.Option> getSelectionList(Class<? extends Model> model, String orderBy, int limit) {
        Mapper mapper = Mapper.of(model);
        Property nameField = mapper.getNameField();
        String name = nameField == null ? "id" : nameField.getName();
        Query<? extends Model> query = Query.of(model);
        if (StringUtils.notBlank((CharSequence)orderBy)) {
            query.order(orderBy);
        }
        return query.select(name).fetch(limit, 0).stream().map(record -> record).map(record -> {
            String key;
            String value;
            Selection.Option option = new Selection.Option();
            option.setValue(record.get("id").toString());
            option.setTitle(record.get(name).toString());
            if (nameField != null && nameField.isTranslatable() && !(value = I18n.get(key = "value:" + option.getTitle())).equals(key)) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put(name, option.getTitle());
                option.setData(data);
                option.setTitle(value);
            }
            return option;
        }).collect(Collectors.toList());
    }

    public static List<Selection.Option> getSelectionList(String selection) {
        if (StringUtils.isBlank((CharSequence)selection)) {
            return null;
        }
        Map<String, Selection.Option> all = MetaStore.buildSelectionMap(selection);
        if (all == null) {
            return null;
        }
        ArrayList<Selection.Option> values = new ArrayList<Selection.Option>(all.values());
        Collections.sort(values, new Comparator<Selection.Option>(){

            @Override
            public int compare(Selection.Option o1, Selection.Option o2) {
                Integer n = o1.getOrder();
                Integer m = o2.getOrder();
                if (n == null) {
                    n = 0;
                }
                if (m == null) {
                    m = 0;
                }
                return Integer.compare(n, m);
            }
        });
        return values;
    }

    public static Selection.Option getSelectionItem(String selection, String value) {
        if (StringUtils.isBlank((CharSequence)selection)) {
            return null;
        }
        Map<String, Selection.Option> all = MetaStore.buildSelectionMap(selection);
        if (all == null) {
            return null;
        }
        return all.get(value);
    }

    private static Map<String, Selection.Option> buildSelectionMap(String selection) {
        List<MetaSelectItem> items = Query.of(MetaSelectItem.class).filter("self.select.name = ?", selection).order("select.priority").order("order").fetch();
        if (items.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Selection.Option> all = new LinkedHashMap<String, Selection.Option>();
        for (MetaSelectItem item : items) {
            if (item.getHidden() == Boolean.TRUE) {
                all.remove(item.getValue());
                continue;
            }
            all.put(item.getValue(), MetaStore.getSelectionItem(item));
        }
        return all;
    }

    private static Selection.Option getSelectionItem(MetaSelectItem item) {
        ObjectMapper objectMapper = Beans.get(ObjectMapper.class);
        Selection.Option option = new Selection.Option();
        option.setValue(item.getValue());
        option.setTitle(item.getTitle());
        option.setIcon(item.getIcon());
        option.setColor(item.getColor());
        option.setOrder(item.getOrder());
        option.setHidden(item.getHidden());
        try {
            option.setData((Map)objectMapper.readValue(item.getData(), (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return option;
    }

    public static void clear() {
        ACTIONS.invalidateAll();
    }

    public static void invalidate(String name) {
        ACTIONS.invalidate((Object)name);
    }
}

