/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="META_ATTACHMENT", uniqueConstraints={@UniqueConstraint(columnNames={"objectName", "objectId", "meta_file"})}, indexes={@Index(columnList="meta_file")})
public class MetaAttachment
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_ATTACHMENT_SEQ")
    @SequenceGenerator(name="META_ATTACHMENT_SEQ", sequenceName="META_ATTACHMENT_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    private String objectName;
    @NotNull
    private Long objectId = 0L;
    @Widget(title="File")
    @NotNull
    @JoinColumn(name="meta_file")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile metaFile;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public Long getObjectId() {
        return this.objectId == null ? 0L : this.objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public MetaFile getMetaFile() {
        return this.metaFile;
    }

    public void setMetaFile(MetaFile metaFile) {
        this.metaFile = metaFile;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaAttachment)) {
            return false;
        }
        MetaAttachment other = (MetaAttachment)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("objectName", (Object)this.getObjectName()).add("objectId", (Object)this.getObjectId()).omitNullValues().toString();
    }
}

