/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="META_FILTER", uniqueConstraints={@UniqueConstraint(columnNames={"name", "filterView"})}, indexes={@Index(columnList="name"), @Index(columnList="title"), @Index(columnList="user_id")})
public class MetaFilter
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_FILTER_SEQ")
    @SequenceGenerator(name="META_FILTER_SEQ", sequenceName="META_FILTER_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    private String name;
    @NameColumn
    @NotNull
    private String title;
    private String filters;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String filterCustom;
    @NotNull
    private String filterView;
    private Boolean shared = Boolean.FALSE;
    @NotNull
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;

    public MetaFilter() {
    }

    public MetaFilter(String name) {
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public String getFilterCustom() {
        return this.filterCustom;
    }

    public void setFilterCustom(String filterCustom) {
        this.filterCustom = filterCustom;
    }

    public String getFilterView() {
        return this.filterView;
    }

    public void setFilterView(String filterView) {
        this.filterView = filterView;
    }

    public Boolean getShared() {
        return this.shared == null ? Boolean.FALSE : this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaFilter)) {
            return false;
        }
        MetaFilter other = (MetaFilter)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("title", (Object)this.getTitle()).add("filters", (Object)this.getFilters()).add("filterView", (Object)this.getFilterView()).add("shared", (Object)this.getShared()).omitNullValues().toString();
    }
}

