/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.db.Model;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="META_HELP", indexes={@Index(columnList="model_name,language,view_name")})
public class MetaHelp
extends Model {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_HELP_SEQ")
    @SequenceGenerator(name="META_HELP_SEQ", sequenceName="META_HELP_SEQ", allocationSize=1)
    private Long id;
    @Column(name="menu_name")
    private String menu;
    @Column(name="model_name")
    private String model;
    @Column(name="field_name")
    private String field;
    @Column(name="view_name")
    private String view;
    @Widget(selection="select.language")
    @NotNull
    private String language;
    private String style;
    @Widget(selection="help.type.selection")
    @Column(name="help_type")
    private String type;
    @Widget(multiline=true)
    @NotNull
    @Size(max=1024)
    @Column(name="help_value")
    private String help;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getMenu() {
        return this.menu;
    }

    public void setMenu(String menu) {
        this.menu = menu;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaHelp)) {
            return false;
        }
        MetaHelp other = (MetaHelp)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("menu", (Object)this.getMenu()).add("model", (Object)this.getModel()).add("field", (Object)this.getField()).add("view", (Object)this.getView()).add("language", (Object)this.getLanguage()).add("style", (Object)this.getStyle()).add("type", (Object)this.getType()).add("help", (Object)this.getHelp()).omitNullValues().toString();
    }
}

