/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.db.Model;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="META_TRANSLATION", uniqueConstraints={@UniqueConstraint(columnNames={"message_key", "language"})})
public class MetaTranslation
extends Model {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_TRANSLATION_SEQ")
    @SequenceGenerator(name="META_TRANSLATION_SEQ", sequenceName="META_TRANSLATION_SEQ", allocationSize=1)
    private Long id;
    @Widget(multiline=true)
    @NotNull
    @Size(max=1024)
    @Column(name="message_key")
    private String key;
    @Widget(multiline=true)
    @Size(max=1024)
    @Column(name="message_value")
    private String message;
    @NotNull
    private String language;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaTranslation)) {
            return false;
        }
        MetaTranslation other = (MetaTranslation)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("key", (Object)this.getKey()).add("message", (Object)this.getMessage()).add("language", (Object)this.getLanguage()).omitNullValues().toString();
    }
}

