/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="META_VIEW", indexes={@Index(columnList="name"), @Index(columnList="title")})
public class MetaView
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_VIEW_SEQ")
    @SequenceGenerator(name="META_VIEW_SEQ", sequenceName="META_VIEW_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    private String name;
    @NameColumn
    @NotNull
    private String title;
    @Widget(selection="view.type.selection")
    @NotNull
    private String type;
    @NotNull
    private Integer priority = 20;
    private String model;
    private String module;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    @NotNull
    private String xml;
    private Boolean computed = Boolean.FALSE;
    @HashKey
    @Column(unique=true)
    private String xmlId;
    private String helpLink;
    private Boolean extension = Boolean.FALSE;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Group> groups;
    private String dependentModules;
    private String dependentFeatures;

    public MetaView() {
    }

    public MetaView(String name) {
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public Boolean getComputed() {
        return this.computed == null ? Boolean.FALSE : this.computed;
    }

    public void setComputed(Boolean computed) {
        this.computed = computed;
    }

    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    public String getHelpLink() {
        return this.helpLink;
    }

    public void setHelpLink(String helpLink) {
        this.helpLink = helpLink;
    }

    public Boolean getExtension() {
        return this.extension == null ? Boolean.FALSE : this.extension;
    }

    public void setExtension(Boolean extension) {
        this.extension = extension;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public void addGroup(Group item) {
        if (this.getGroups() == null) {
            this.setGroups(new HashSet<Group>());
        }
        this.getGroups().add(item);
    }

    public void removeGroup(Group item) {
        if (this.getGroups() == null) {
            return;
        }
        this.getGroups().remove(item);
    }

    public void clearGroups() {
        if (this.getGroups() != null) {
            this.getGroups().clear();
        }
    }

    public String getDependentModules() {
        return this.dependentModules;
    }

    public void setDependentModules(String dependentModules) {
        this.dependentModules = dependentModules;
    }

    public String getDependentFeatures() {
        return this.dependentFeatures;
    }

    public void setDependentFeatures(String dependentFeatures) {
        this.dependentFeatures = dependentFeatures;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaView)) {
            return false;
        }
        MetaView other = (MetaView)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getXmlId(), other.getXmlId());
    }

    public int hashCode() {
        return Objects.hash(-385769878, this.getXmlId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("title", (Object)this.getTitle()).add("type", (Object)this.getType()).add("priority", (Object)this.getPriority()).add("model", (Object)this.getModel()).add("module", (Object)this.getModule()).add("computed", (Object)this.getComputed()).add("xmlId", (Object)this.getXmlId()).add("helpLink", (Object)this.getHelpLink()).add("extension", (Object)this.getExtension()).add("dependentModules", (Object)this.getDependentModules()).omitNullValues().toString();
    }
}

