/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db.repo;

import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaJsonModel;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.meta.db.MetaMenu;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.repo.AbstractMetaJsonModelRepository;
import com.axelor.meta.db.repo.MetaJsonRecordRepository;
import com.google.common.base.Objects;
import com.google.inject.persist.Transactional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;

public class MetaJsonModelRepository
extends AbstractMetaJsonModelRepository {
    public MetaJsonField findNameField(MetaJsonModel jsonModel) {
        return jsonModel.getFields().stream().filter(f -> f.getNameField() == Boolean.TRUE).findFirst().orElseGet(() -> jsonModel.getFields().stream().filter(f -> "name".equalsIgnoreCase(f.getName()) || "fullName".equalsIgnoreCase(f.getName())).findFirst().orElse(null));
    }

    private void onSave(MetaJsonModel jsonModel) {
        if (jsonModel.getFields() == null) {
            return;
        }
        MetaJsonField nameField = this.findNameField(jsonModel);
        String lastName = jsonModel.getNameField();
        if (nameField == null) {
            jsonModel.setNameField(null);
        } else {
            jsonModel.setNameField(nameField.getName());
        }
        if (!Objects.equal((Object)lastName, (Object)jsonModel.getNameField())) {
            MetaJsonRecordRepository records = Beans.get(MetaJsonRecordRepository.class);
            records.all(jsonModel.getName()).fetchStream().forEach(records::save);
        }
        MetaView gridView = jsonModel.getGridView();
        String orderBy = jsonModel.getOrderBy();
        String groupBy = jsonModel.getGroupBy();
        if (gridView == null) {
            gridView = new MetaView();
            gridView.setType("grid");
            gridView.setModel(MetaJsonRecord.class.getName());
        }
        StringBuilder gridXml = new StringBuilder().append("<grid").append(" name=").append('\"').append(gridView.getName()).append('\"').append(" title=").append('\"').append(gridView.getTitle()).append('\"').append(" model=").append('\"').append(gridView.getModel()).append('\"');
        Function<String, String> fixCommaList = value -> Stream.of(value.split(",")).map(String::trim).map(s -> {
            if (s.startsWith("-attrs.") || s.startsWith("attrs.")) {
                return s;
            }
            if (s.startsWith("-")) {
                return "-attrs." + s.substring(1);
            }
            return "attrs." + s;
        }).collect(Collectors.joining(","));
        if (StringUtils.notBlank((CharSequence)orderBy)) {
            gridXml.append(" orderBy=").append('\"').append(fixCommaList.apply(orderBy)).append('\"');
        }
        if (StringUtils.notBlank((CharSequence)groupBy)) {
            gridXml.append(" groupBy=").append('\"').append(fixCommaList.apply(groupBy)).append('\"');
        }
        gridXml.append(">\n").append("  <field name=\"attrs\" x-json-model=\"" + jsonModel.getName() + "\"/>\n").append("</grid>\n");
        gridView.setName("custom-model-" + jsonModel.getName() + "-grid");
        gridView.setTitle(jsonModel.getTitle());
        gridView.setXml(gridXml.toString());
        String onNew = jsonModel.getOnNew();
        String onSave = jsonModel.getOnSave();
        String width = jsonModel.getFormWidth();
        onNew = StringUtils.isBlank((CharSequence)onNew) ? "action-json-record-defaults" : "action-json-record-defaults," + onNew;
        MetaView formView = jsonModel.getFormView();
        if (formView == null) {
            formView = new MetaView();
            formView.setType("form");
            formView.setModel(MetaJsonRecord.class.getName());
        }
        formView.setName("custom-model-" + jsonModel.getName() + "-form");
        formView.setTitle(jsonModel.getTitle());
        StringBuilder xml = new StringBuilder().append("<form").append(" name=").append('\"').append(formView.getName()).append('\"').append(" title=").append('\"').append(formView.getTitle()).append('\"').append(" model=").append('\"').append(formView.getModel()).append('\"').append(" onNew=").append('\"').append(onNew).append('\"');
        if (!StringUtils.isBlank((CharSequence)onSave)) {
            xml.append(" onSave=").append('\"').append(onSave).append('\"');
        }
        if (!StringUtils.isBlank((CharSequence)width)) {
            xml.append(" width=").append('\"').append(width).append('\"');
        }
        xml.append(">\n").append("  <panel title=\"Overview\" itemSpan=\"12\">\n").append("    <field name=\"attrs\" x-json-model=\"" + jsonModel.getName() + "\"/>\n").append("  </panel>\n").append("</form>\n");
        formView.setXml(xml.toString());
        if (StringUtils.notBlank((CharSequence)jsonModel.getMenuTitle())) {
            MetaAction action;
            MetaMenu menu = jsonModel.getMenu();
            if (menu == null) {
                menu = new MetaMenu();
            }
            menu.setName("menu-json-model-" + jsonModel.getName());
            menu.setTitle(jsonModel.getMenuTitle() == null ? jsonModel.getTitle() : jsonModel.getMenuTitle());
            menu.setParent(jsonModel.getMenuParent());
            menu.setIcon(jsonModel.getMenuIcon());
            menu.setIconBackground(jsonModel.getMenuBackground());
            menu.setOrder(jsonModel.getMenuOrder());
            menu.setTop(jsonModel.getMenuTop());
            if (jsonModel.getRoles() != null) {
                jsonModel.getRoles().forEach(menu::addRole);
            }
            if ((action = jsonModel.getAction()) == null) {
                action = new MetaAction();
                action.setType("action-view");
                action.setModel(MetaJsonRecord.class.getName());
            }
            action.setName("all.json." + jsonModel.getName());
            action.setXml("<action-view" + " name=" + '\"' + action.getName() + '\"' + " title=" + '\"' + menu.getTitle() + '\"' + " model=" + '\"' + action.getModel() + '\"' + ">\n" + "  <view type=\"grid\" name=\"" + gridView.getName() + "\" />\n" + "  <view type=\"form\" name=\"" + formView.getName() + "\" />\n" + "  <domain>self.jsonModel = :jsonModel</domain>\n" + ("  <context name=\"jsonModel\" expr=\"" + jsonModel.getName() + "\" />\n") + "</action-view>\n");
            menu.setAction(action);
            MetaStore.invalidate(action.getName());
            jsonModel.setMenu(menu);
            jsonModel.setAction(action);
        }
        jsonModel.setGridView(gridView);
        jsonModel.setFormView(formView);
    }

    @Override
    @Transactional
    public MetaJsonModel save(MetaJsonModel entity) {
        this.onSave(entity);
        return super.save(entity);
    }

    @Override
    @Transactional
    public void remove(MetaJsonModel entity) {
        Model[] related;
        EntityManager em = JPA.em();
        for (Model item : related = new Model[]{entity.getGridView(), entity.getFormView(), entity.getMenu(), entity.getAction()}) {
            if (item == null) continue;
            em.remove((Object)item);
        }
        super.remove(entity);
        JPA.all(MetaJsonRecord.class).filter("self.jsonModel = ?", entity.getName()).remove();
    }
}

