/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.db.JPA;
import com.axelor.meta.loader.Module;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLoader {
    protected Logger log = LoggerFactory.getLogger(this.getClass().getSuperclass());
    private static final Set<Map.Entry<Class<?>, String>> visited = new HashSet();
    private static final Map<Class<?>, Multimap<String, Long>> unresolved = new HashMap();
    private static final List<Runnable> resolveTasks = new ArrayList<Runnable>();

    AbstractLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isVisited(Class<?> type, String name) {
        Set<Map.Entry<Class<?>, String>> set = visited;
        synchronized (set) {
            AbstractMap.SimpleImmutableEntry key = new AbstractMap.SimpleImmutableEntry(type, name);
            if (visited.contains(key)) {
                this.log.error("duplicate {} found: {}", (Object)type.getSimpleName(), (Object)name);
                return true;
            }
            visited.add(key);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void setUnresolved(Class<T> type, String unresolvedKey, Long entityId) {
        Map<Class<?>, Multimap<String, Long>> map = unresolved;
        synchronized (map) {
            Multimap mm = unresolved.computeIfAbsent(type, key -> HashMultimap.create());
            mm.put((Object)unresolvedKey, (Object)entityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Set<Long> resolve(Class<T> type, String unresolvedKey) {
        Map<Class<?>, Multimap<String, Long>> map = unresolved;
        synchronized (map) {
            HashSet entityIds = Sets.newHashSet();
            Multimap<String, Long> mm = unresolved.get(type);
            if (mm == null) {
                return entityIds;
            }
            for (Long item : mm.get((Object)unresolvedKey)) {
                entityIds.add(item);
            }
            mm.removeAll((Object)unresolvedKey);
            return entityIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResolveTask(Class<?> type, String name, Long entityId, BiConsumer<Long, Long> consumer) {
        Runnable task = () -> this.resolve(type, name).forEach(id -> consumer.accept((Long)id, entityId));
        List<Runnable> list = resolveTasks;
        synchronized (list) {
            resolveTasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runResolveTasks() {
        if (resolveTasks.isEmpty()) {
            return;
        }
        List<Runnable> list = resolveTasks;
        synchronized (list) {
            resolveTasks.parallelStream().forEach(task -> JPA.runInTransaction(task::run));
            resolveTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> unresolvedKeys() {
        Map<Class<?>, Multimap<String, Long>> map = unresolved;
        synchronized (map) {
            HashSet names = Sets.newHashSet();
            for (Multimap<String, Long> mm : unresolved.values()) {
                names.addAll(mm.keySet());
            }
            return names;
        }
    }

    protected abstract void doLoad(Module var1, boolean var2);

    void doLast(Module module, boolean update) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doCleanUp() {
        List<Runnable> list = visited;
        synchronized (list) {
            visited.clear();
        }
        list = unresolved;
        synchronized (list) {
            unresolved.clear();
        }
        list = resolveTasks;
        synchronized (list) {
            resolveTasks.clear();
        }
    }

    public final void load(Module module, boolean update) {
        this.doLoad(module, update);
    }
}

