/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.db.ParallelTransactionExecutor;
import com.axelor.meta.loader.AbstractLoader;
import com.axelor.meta.loader.Module;
import com.axelor.meta.loader.ModuleManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;

abstract class AbstractParallelLoader
extends AbstractLoader {
    AbstractParallelLoader() {
    }

    protected abstract List<List<URL>> findFileLists(Module var1);

    protected abstract void doLoad(URL var1, Module var2, boolean var3);

    @Override
    protected void doLoad(Module module, boolean update) {
        this.findFileLists(module).stream().flatMap(Collection::stream).forEach(file -> this.doLoad((URL)file, module, update));
    }

    protected void feedTransactionExecutor(ParallelTransactionExecutor transactionExecutor, Module module, boolean update, Set<Path> paths) {
        ListIterator<List<URL>> it = this.findFileLists(module, paths).listIterator();
        while (it.hasNext()) {
            int priority = it.nextIndex();
            List<URL> files = it.next();
            files.parallelStream().forEach(file -> transactionExecutor.add(() -> this.doLoad((URL)file, module, update), priority));
        }
    }

    private List<List<URL>> findFileLists(Module module, Set<Path> paths) {
        List<List<URL>> lists = this.findFileLists(module);
        if (paths.isEmpty()) {
            return lists;
        }
        List<List<URL>> foundInJar = this.findFileListsJar(lists);
        if (foundInJar.parallelStream().anyMatch(list -> !list.isEmpty())) {
            return foundInJar;
        }
        return lists.parallelStream().map(list -> list.parallelStream().filter(url -> "file".equals(url.getProtocol()) && paths.contains(Paths.get(this.toUri((URL)url)))).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private List<List<URL>> findFileListsJar(List<List<URL>> lists) {
        return lists.stream().flatMap(Collection::stream).findAny().filter(url -> "jar".equals(url.getProtocol())).map(url -> {
            try (FileSystem fs = FileSystems.newFileSystem(this.toUri((URL)url), Collections.emptyMap());){
                List list2 = lists.parallelStream().map(list -> list.parallelStream().filter(urlInFs -> this.getLastModifiedTimeMillis(fs, (URL)urlInFs) >= ModuleManager.getLastRestored()).collect(Collectors.toList())).collect(Collectors.toList());
                return list2;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).orElse(Collections.emptyList());
    }

    private URI toUri(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private long getLastModifiedTimeMillis(FileSystem fs, URL url) {
        Path path = fs.getPath(Paths.get(this.toUri(url)).toString(), new String[0]);
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

