/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.common.FileUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.meta.MetaScanner;
import com.axelor.meta.db.MetaTranslation;
import com.axelor.meta.db.repo.MetaTranslationRepository;
import com.axelor.meta.loader.AbstractParallelLoader;
import com.axelor.meta.loader.Module;
import com.axelor.meta.loader.ModuleManager;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.persist.Transactional;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class I18nLoader
extends AbstractParallelLoader {
    @Inject
    private MetaTranslationRepository translations;

    private <T> List<List<T>> separateFiles(List<T> files) {
        ArrayList<T> main = new ArrayList<T>();
        ArrayList<T> custom = new ArrayList<T>();
        Pattern pattern = Pattern.compile(".*(?:custom_)(\\w+)\\.csv$");
        for (T file : files) {
            String name = file.toString();
            if (pattern.matcher(name).matches()) {
                custom.add(file);
                continue;
            }
            main.add(file);
        }
        return ImmutableList.of(main, custom);
    }

    @Override
    protected void doLoad(URL file, Module module, boolean update) {
        this.log.debug("Load translation: {}", (Object)file.getFile());
        try (InputStream is = file.openStream();){
            this.process(is, file.getFile());
        }
        catch (IOException e) {
            this.log.error("Unable to import file: {}", (Object)file.getFile());
        }
    }

    @Override
    protected List<List<URL>> findFileLists(Module module) {
        List<URL> files = MetaScanner.findAll(module.getName(), "i18n", "(.*?)\\.csv");
        return this.separateFiles(files);
    }

    @Transactional
    public void load(String importPath) {
        for (Module module : ModuleManager.getAll()) {
            if (Strings.isNullOrEmpty((String)importPath)) {
                this.doLoad(module, false);
                continue;
            }
            this.loadModule(module, importPath);
        }
    }

    private void loadModule(Module module, String importPath) {
        File moduleDir = FileUtils.getFile((String)importPath, (String[])new String[]{module.getName()});
        if (!moduleDir.exists() || !moduleDir.isDirectory() || moduleDir.listFiles() == null) {
            return;
        }
        this.log.debug("Load {} translations", (Object)module.getName());
        List<List<File>> fileLists = this.separateFiles(Arrays.asList(moduleDir.listFiles()));
        fileLists.forEach(files -> files.forEach(file -> {
            try (FileInputStream is = new FileInputStream((File)file);){
                this.process(is, file.getPath());
            }
            catch (IOException e) {
                this.log.error("Unable to import file: {}", (Object)file.getName());
            }
        }));
    }

    private void process(InputStream stream, String fileName) throws IOException {
        String language = "";
        Pattern pattern = Pattern.compile(".*(?:messages_|custom_)([a-zA-Z_]+)\\.csv$");
        Matcher matcher = pattern.matcher(fileName);
        if (!matcher.matches()) {
            return;
        }
        language = matcher.group(1);
        try (InputStreamReader reader = new InputStreamReader(stream, Charsets.UTF_8);
             CSVReader csvReader = new CSVReader((Reader)reader, ',', '\"', '\u0000');){
            String[] fields = csvReader.readNext();
            String[] values = null;
            int counter = 0;
            while ((values = csvReader.readNext()) != null) {
                if (this.isEmpty(values)) continue;
                Map<String, String> map = this.toMap(fields, values);
                String key = map.get("key");
                String message = map.get("message");
                if (StringUtils.isBlank((CharSequence)key)) continue;
                MetaTranslation entity = this.translations.findByKey(key, language);
                if (entity == null) {
                    entity = new MetaTranslation();
                    entity.setKey(key);
                    entity.setLanguage(language);
                    entity.setMessage(message);
                } else if (!StringUtils.isBlank((CharSequence)message)) {
                    entity.setMessage(message);
                }
                this.translations.save(entity);
                if (counter++ % 20 != 0) continue;
                JPA.em().flush();
                JPA.em().clear();
            }
        }
    }

    private Map<String, String> toMap(String[] fields, String[] values) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < fields.length; ++i) {
            map.put(fields[i], values[i]);
        }
        return map;
    }

    private boolean isEmpty(String[] line) {
        if (line == null || line.length == 0) {
            return true;
        }
        return line.length == 1 && (line[0] == null || "".equals(line[0].trim()));
    }
}

