/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;

final class Module {
    private String name;
    private List<Module> depends = new ArrayList<Module>();
    private String version;
    private String installedVersion;
    private boolean application = false;
    private boolean installed = false;
    private boolean removable = false;
    private boolean pending = false;

    public Module(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Module> getDepends() {
        return this.depends;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getInstalledVersion() {
        return this.installedVersion;
    }

    public void setInstalledVersion(String installedVersion) {
        this.installedVersion = installedVersion;
    }

    public boolean isApplication() {
        return this.application;
    }

    public void setApplication(boolean application) {
        this.application = application;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }

    public boolean isUpgradable() {
        return this.installed && !Objects.equal((Object)this.version, (Object)this.installedVersion);
    }

    public void dependsOn(Module module) {
        if (!this.depends.contains(module)) {
            this.depends.add(module);
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Module.class.getName(), this.name});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Module)) {
            return false;
        }
        return this.name.equals(((Module)obj).name);
    }

    public String pprint(int depth) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append("\n");
        for (Module dep : this.depends) {
            builder.append(Strings.repeat((String)"  ", (int)depth)).append("-> ").append(dep.pprint(depth + 1));
        }
        return builder.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("version", (Object)this.version).toString();
    }
}

