/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.auth.db.Group;
import com.axelor.auth.db.repo.GroupRepository;
import com.axelor.common.FileUtils;
import com.axelor.common.Inflector;
import com.axelor.common.ObjectUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaScanner;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaActionMenu;
import com.axelor.meta.db.MetaMenu;
import com.axelor.meta.db.MetaSelect;
import com.axelor.meta.db.MetaSelectItem;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.repo.MetaActionMenuRepository;
import com.axelor.meta.db.repo.MetaActionRepository;
import com.axelor.meta.db.repo.MetaMenuRepository;
import com.axelor.meta.db.repo.MetaSelectRepository;
import com.axelor.meta.db.repo.MetaViewRepository;
import com.axelor.meta.loader.AbstractParallelLoader;
import com.axelor.meta.loader.ModelLoader;
import com.axelor.meta.loader.Module;
import com.axelor.meta.loader.ModuleManager;
import com.axelor.meta.loader.XMLViews;
import com.axelor.meta.schema.ObjectViews;
import com.axelor.meta.schema.actions.Action;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.meta.schema.views.AbstractWidget;
import com.axelor.meta.schema.views.ExtendableView;
import com.axelor.meta.schema.views.FormView;
import com.axelor.meta.schema.views.GridView;
import com.axelor.meta.schema.views.MenuItem;
import com.axelor.meta.schema.views.Panel;
import com.axelor.meta.schema.views.PanelField;
import com.axelor.meta.schema.views.PanelRelated;
import com.axelor.meta.schema.views.Selection;
import com.axelor.meta.service.MetaService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;

public class ViewLoader
extends AbstractParallelLoader {
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private MetaViewRepository views;
    @Inject
    private MetaSelectRepository selects;
    @Inject
    private MetaActionRepository actions;
    @Inject
    private MetaMenuRepository menus;
    @Inject
    private MetaActionMenuRepository actionMenus;
    @Inject
    private GroupRepository groups;
    @Inject
    private XMLViews.FinalViewGenerator finalViewGenerator;
    private final Set<String> viewsToGenerate = ConcurrentHashMap.newKeySet();
    private final Map<String, List<String>> viewsToMigrate = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, List<Consumer<Group>>> groupsToCreate = new ConcurrentHashMap<String, List<Consumer<Group>>>();
    private static final File outputDir = FileUtils.getFile((String)System.getProperty("java.io.tmpdir"), (String[])new String[]{"axelor", "generated"});

    @Override
    protected void doLoad(URL file, Module module, boolean update) {
        this.log.debug("Importing: {}", (Object)file.getFile());
        try {
            this.process(file, module, update);
        }
        catch (IOException | JAXBException e) {
            this.log.error("Error while loading {}", (Object)file);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<List<URL>> findFileLists(Module module) {
        return ImmutableList.of(MetaScanner.findAll(module.getName(), "views", "(.*?)\\.xml"));
    }

    @Override
    @Transactional
    protected void doLast(Module module, boolean update) {
        this.importDefault(module);
        this.runResolveTasks();
        Set<String> unresolved = this.unresolvedKeys();
        if (!unresolved.isEmpty()) {
            this.log.error("Unresolved items: {}", unresolved);
            throw new PersistenceException("There are some unresolve items; check the log.");
        }
        this.migrateViews();
        this.linkMissingGroups();
        this.generateFinalViews(update);
    }

    private void migrateViews() {
        try {
            this.viewsToMigrate.forEach((name, xmlIds) -> {
                MetaView baseView = this.views.findByNameAndComputed((String)name, false);
                if (baseView != null) {
                    this.views.all().filter("self.xmlId IN :xmlIds").bind("xmlIds", xmlIds).update("priority", baseView.getPriority());
                }
            });
        }
        finally {
            this.viewsToMigrate.clear();
        }
    }

    private void linkMissingGroups() {
        try {
            this.groupsToCreate.forEach((code, adders) -> {
                Group group;
                Group existingGroup = this.groups.findByCode((String)code);
                if (existingGroup != null) {
                    this.log.debug("User group already created by data/demo: {}", code);
                    group = existingGroup;
                } else {
                    this.log.info("Creating a new user group: {}", code);
                    group = this.groups.save(new Group((String)code, (String)code));
                }
                adders.forEach(adder -> adder.accept(group));
            });
        }
        finally {
            this.groupsToCreate.clear();
        }
    }

    private void generateFinalViews(boolean update) {
        try {
            this.finalViewGenerator.generate(this.viewsToGenerate, update);
        }
        finally {
            this.viewsToGenerate.clear();
        }
    }

    private static <T> List<T> getList(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    void updateFrom(Path file, String moduleName) throws IOException, JAXBException {
        Module module = ModuleManager.getModule(moduleName);
        try {
            this.process(file.toUri().toURL(), module, true);
        }
        finally {
            ViewLoader.doCleanUp();
        }
    }

    void process(URL url, Module module, boolean update) throws IOException, JAXBException {
        ObjectViews all;
        try (InputStream stream = url.openStream();){
            all = XMLViews.unmarshal(stream);
        }
        ViewLoader.getList(all.getViews()).forEach(view -> this.importView((AbstractView)view, module, update, ViewLoader.getFileName(url)));
        ViewLoader.getList(all.getSelections()).forEach(selection -> this.importSelection((Selection)selection, module, update));
        ViewLoader.getList(all.getActions()).forEach(action -> {
            this.importAction((Action)action, module, update);
            MetaStore.invalidate(action.getName());
        });
        ViewLoader.getList(all.getMenus()).forEach(item -> this.importMenu((MenuItem)item, module, update));
        ViewLoader.getList(all.getActionMenus()).forEach(item -> this.importActionMenu((MenuItem)item, module, update));
    }

    private static String getFileName(URL url) {
        String urlStr = url.getFile();
        return urlStr.substring(urlStr.lastIndexOf(47) + 1);
    }

    private void importView(AbstractView view, Module module, boolean update, String sourceFile) {
        this.importView(view, module, update, sourceFile, -1);
    }

    private void importView(AbstractView view, Module module, boolean update, String sourceFile, int priority) {
        int deleted;
        String xmlId = view.getXmlId();
        String name = view.getName();
        String type = view.getType();
        String modelName = view.getModel();
        if (StringUtils.isBlank((CharSequence)xmlId)) {
            if (this.isVisited(view.getClass(), name)) {
                this.log.error("duplicate view without 'id': {}", (Object)name);
                return;
            }
        } else if (this.isVisited(view.getClass(), xmlId)) {
            return;
        }
        if (view instanceof ExtendableView) {
            ExtendableView extendableView = (ExtendableView)((Object)view);
            if (Boolean.TRUE.equals(view.getExtension())) {
                this.viewsToGenerate.add(view.getName());
            } else if (ObjectUtils.notEmpty(extendableView.getExtends())) {
                this.log.error("View with extensions must have extension=\"true\": {}", (Object)ViewLoader.getName(name, xmlId));
                return;
            }
        }
        this.log.debug("Loading view: {}", (Object)ViewLoader.getName(name, xmlId));
        String xml = XMLViews.toXml(view, true);
        if (type.matches("tree|chart|portal|dashboard|search|custom")) {
            modelName = null;
        } else if (StringUtils.isBlank((CharSequence)modelName)) {
            throw new IllegalArgumentException("Invalid view, model name missing.");
        }
        if (modelName != null) {
            Class<?> model;
            try {
                model = Class.forName(modelName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Invalid view, model not found: " + modelName);
            }
            modelName = model.getName();
        }
        MetaView entity = this.views.findByID(xmlId);
        MetaView other = this.views.findByNameAndComputed(name, false);
        if (entity == null && StringUtils.isBlank((CharSequence)xmlId)) {
            entity = (MetaView)this.views.all().filter("self.name = ? AND self.module = ? AND self.xmlId IS NULL AND COALESCE(self.computed, FALSE) = FALSE", name, module.getName()).fetchOne();
        }
        if (entity == null) {
            entity = new MetaView(name);
        }
        if (other == entity) {
            other = null;
        }
        if (Boolean.TRUE.equals(view.getExtension())) {
            if (!Boolean.TRUE.equals(entity.getExtension())) {
                this.viewsToMigrate.computeIfAbsent(view.getName(), k -> Collections.synchronizedList(new ArrayList())).add(view.getXmlId());
            }
        } else if (entity.getId() == null && other != null && !Objects.equal((Object)xmlId, (Object)other.getXmlId())) {
            entity.setPriority(other.getPriority() + 1);
        }
        if (entity.getId() != null && !update) {
            return;
        }
        if (priority > -1) {
            entity.setPriority(priority);
        }
        if ("dashboard".equals(type) && !xml.equals(entity.getXml()) && (deleted = Beans.get(MetaService.class).removeCustomViews(entity)) > 0) {
            this.log.info("{} custom views are deleted: {}", (Object)deleted, (Object)entity.getName());
        }
        entity.setXmlId(xmlId);
        entity.setTitle(view.getTitle());
        entity.setType(type);
        entity.setModel(modelName);
        entity.setModule(module.getName());
        entity.setXml(xml);
        entity.setComputed(null);
        Set<String> missingGroups = this.addGroups(entity::addGroup, view.getGroups());
        entity.setExtension(view.getExtension());
        if (entity.getTitle() == null) {
            entity.setTitle(name);
        }
        if (entity.getHelpLink() == null) {
            entity.setHelpLink(view.getHelpLink());
        }
        entity = this.views.save(entity);
        this.addToGroupsToCreate(entity, missingGroups);
    }

    private static String getName(String name, String xmlId) {
        return xmlId == null ? name : String.format("%s(id=%s)", name, xmlId);
    }

    @Transactional
    protected void importSelection(Selection selection, Module module, boolean update) {
        String name = selection.getName();
        String xmlId = selection.getXmlId();
        if (StringUtils.isBlank((CharSequence)xmlId)) {
            if (this.isVisited(Selection.class, name)) {
                this.log.error("duplicate selection without 'id': {}", (Object)name);
                return;
            }
        } else if (this.isVisited(Selection.class, xmlId)) {
            return;
        }
        this.log.debug("Loading selection: {}", (Object)name);
        MetaSelect entity = this.selects.findByID(xmlId);
        MetaSelect other = this.selects.findByName(selection.getName());
        if (entity == null) {
            entity = (MetaSelect)this.selects.all().filter("self.name = ? AND self.module = ?", name, module.getName()).fetchOne();
        }
        if (entity == null) {
            entity = new MetaSelect(selection.getName());
            entity.setXmlId(xmlId);
        }
        if (other == entity) {
            other = null;
        }
        if (entity.getId() == null && other != null && !Objects.equal((Object)xmlId, (Object)other.getXmlId())) {
            entity.setPriority(other.getPriority() + 1);
        }
        if (entity.getId() != null && !update) {
            return;
        }
        entity.clearItems();
        entity.setModule(module.getName());
        int sequence = 0;
        for (Selection.Option opt : selection.getOptions()) {
            MetaSelectItem item = new MetaSelectItem();
            Integer seq = sequence++;
            if (opt.getOrder() != null) {
                seq = opt.getOrder();
            }
            item.setValue(opt.getValue());
            item.setTitle(opt.getTitle());
            item.setIcon(opt.getIcon());
            item.setColor(opt.getColor());
            item.setOrder(seq);
            item.setHidden(opt.getHidden());
            entity.addItem(item);
            if (opt.getDataAttributes() == null) continue;
            HashMap data = Maps.newHashMap();
            for (QName param : opt.getDataAttributes().keySet()) {
                String paramName = param.getLocalPart();
                if (!paramName.startsWith("data-")) continue;
                data.put(paramName.substring(5), opt.getDataAttributes().get(param));
            }
            try {
                item.setData(this.objectMapper.writeValueAsString((Object)data));
            }
            catch (JsonProcessingException jsonProcessingException) {}
        }
        this.selects.save(entity);
    }

    private Set<String> addGroups(Consumer<Group> adder, String codes) {
        HashSet<String> missing = new HashSet<String>();
        if (StringUtils.notBlank((CharSequence)codes)) {
            Arrays.stream(codes.split("\\s*,\\s*")).forEach(code -> {
                Group group = this.groups.findByCode((String)code);
                if (group != null) {
                    adder.accept(group);
                } else {
                    missing.add((String)code);
                }
            });
        }
        return missing;
    }

    private void addToGroupsToCreate(MetaView metaView, Set<String> codes) {
        Long id = metaView.getId();
        codes.stream().forEach(code -> this.groupsToCreate.computeIfAbsent((String)code, k -> Collections.synchronizedList(new ArrayList())).add(group -> {
            MetaView entity = (MetaView)this.views.find(id);
            entity.addGroup((Group)group);
        }));
    }

    private void addToGroupsToCreate(MetaMenu metaMenu, Set<String> codes) {
        Long id = metaMenu.getId();
        codes.stream().forEach(code -> this.groupsToCreate.computeIfAbsent((String)code, k -> Collections.synchronizedList(new ArrayList())).add(group -> {
            MetaMenu entity = (MetaMenu)this.menus.find(id);
            entity.addGroup((Group)group);
        }));
    }

    @Transactional
    protected void importAction(Action action, Module module, boolean update) {
        String name = action.getName();
        String xmlId = action.getXmlId();
        if (StringUtils.isBlank((CharSequence)xmlId)) {
            if (this.isVisited(Action.class, name)) {
                this.log.error("duplicate action without 'id': {}", (Object)name);
                return;
            }
        } else if (this.isVisited(Action.class, xmlId)) {
            return;
        }
        this.log.debug("Loading action: {}", (Object)name);
        MetaAction entity = this.actions.findByID(xmlId);
        MetaAction other = this.actions.findByName(name);
        if (entity == null) {
            entity = (MetaAction)this.actions.all().filter("self.name = ? AND self.module = ?", name, module.getName()).fetchOne();
        }
        if (entity == null) {
            entity = new MetaAction(name);
            entity.setXmlId(xmlId);
        }
        if (other == entity) {
            other = null;
        }
        if (entity.getId() == null && other != null && !Objects.equal((Object)xmlId, (Object)other.getXmlId())) {
            entity.setPriority(other.getPriority() + 1);
        }
        if (entity.getId() != null && !update) {
            return;
        }
        Class<?> klass = action.getClass();
        Mapper mapper = Mapper.of(klass);
        entity.setXml(XMLViews.toXml(action, true));
        String model = (String)mapper.get(action, "model");
        entity.setModel(model);
        entity.setModule(module.getName());
        String type = klass.getSimpleName().replaceAll("([a-z\\d])([A-Z]+)", "$1-$2").toLowerCase();
        entity.setType(type);
        if (action instanceof ActionView) {
            ActionView view = (ActionView)action;
            Boolean home = view.getHome();
            if (home == null) {
                for (ActionView.View item : view.getViews()) {
                    if (!"dashboard".equals(item.getType())) continue;
                    home = Boolean.TRUE;
                    break;
                }
            }
            entity.setHome(home);
        }
        entity = this.actions.save(entity);
        Long entityId = entity.getId();
        this.addResolveTask(MetaMenu.class, name, entityId, this::resolveActionOnMenu);
        this.addResolveTask(MetaActionMenu.class, name, entityId, this::resolveActionOnActionMenu);
    }

    private void resolveActionOnMenu(Long menuId, Long actionId) {
        MetaMenu pending = (MetaMenu)this.menus.find(menuId);
        this.log.debug("Resolved menu: {}", (Object)pending.getName());
        MetaAction actionEntity = (MetaAction)this.actions.find(actionId);
        pending.setAction(actionEntity);
    }

    private void resolveActionOnActionMenu(Long menuId, Long actionId) {
        MetaActionMenu pending = (MetaActionMenu)this.actionMenus.find(menuId);
        this.log.debug("Resolved action menu: {}", (Object)pending.getName());
        MetaAction actionEntity = (MetaAction)this.actions.find(actionId);
        pending.setAction(actionEntity);
    }

    @Transactional
    protected void importMenu(MenuItem menuItem, Module module, boolean update) {
        String name = menuItem.getName();
        String xmlId = menuItem.getXmlId();
        if (StringUtils.isBlank((CharSequence)xmlId)) {
            if (this.isVisited(MenuItem.class, name)) {
                this.log.error("duplicate menu without 'id': {}", (Object)name);
                return;
            }
        } else if (this.isVisited(MenuItem.class, xmlId)) {
            return;
        }
        this.log.debug("Loading menu: {}", (Object)name);
        MetaMenu entity = this.menus.findByID(xmlId);
        MetaMenu other = this.menus.findByName(name);
        if (entity == null) {
            entity = (MetaMenu)this.menus.all().filter("self.name = ? AND self.module = ?", name, module.getName()).fetchOne();
        }
        if (entity == null) {
            entity = new MetaMenu(name);
            entity.setXmlId(xmlId);
        }
        if (other == entity) {
            other = null;
        }
        if (entity.getId() == null && other != null && !Objects.equal((Object)xmlId, (Object)other.getXmlId())) {
            entity.setPriority(other.getPriority() + 1);
        }
        if (entity.getId() != null && !update) {
            return;
        }
        entity.setTitle(menuItem.getTitle());
        entity.setIcon(menuItem.getIcon());
        entity.setIconBackground(menuItem.getIconBackground());
        entity.setModule(module.getName());
        entity.setTag(menuItem.getTag());
        entity.setTagGet(menuItem.getTagGet());
        entity.setTagCount(menuItem.getTagCount());
        entity.setTagStyle(menuItem.getTagStyle());
        entity.setTop(menuItem.getTop());
        entity.setLeft(menuItem.getLeft() == null ? true : menuItem.getLeft());
        entity.setMobile(menuItem.getMobile());
        entity.setHidden(menuItem.getHidden());
        Set<String> missingGroups = this.addGroups(entity::addGroup, menuItem.getGroups());
        entity.setConditionToCheck(menuItem.getConditionToCheck());
        entity.setModuleToCheck(menuItem.getModuleToCheck());
        if (menuItem.getOrder() != null) {
            entity.setOrder(menuItem.getOrder());
        }
        entity = this.menus.save(entity);
        if (!Strings.isNullOrEmpty((String)menuItem.getParent())) {
            MetaMenu parent = this.menus.findByName(menuItem.getParent());
            if (parent == null) {
                this.log.debug("Unresolved parent: {}", (Object)menuItem.getParent());
                this.setUnresolved(MetaMenu.class, menuItem.getParent(), entity.getId());
            } else {
                entity.setParent(parent);
            }
        }
        if (!StringUtils.isBlank((CharSequence)menuItem.getAction())) {
            MetaAction action = this.actions.findByName(menuItem.getAction());
            if (action == null) {
                this.log.debug("Unresolved action: {}", (Object)menuItem.getAction());
                this.setUnresolved(MetaMenu.class, menuItem.getAction(), entity.getId());
            } else {
                entity.setAction(action);
            }
        }
        Long entityId = entity.getId();
        this.addResolveTask(MetaMenu.class, name, entityId, this::resolveParentOnMenu);
        this.addToGroupsToCreate(entity, missingGroups);
    }

    private void resolveParentOnMenu(Long menuId, Long parentMenuId) {
        MetaMenu pending = (MetaMenu)this.menus.find(menuId);
        this.log.debug("Resolved menu: {}", (Object)pending.getName());
        MetaMenu metaMenuEntity = (MetaMenu)this.menus.find(parentMenuId);
        pending.setParent(metaMenuEntity);
    }

    @Transactional
    protected void importActionMenu(MenuItem menuItem, Module module, boolean update) {
        String name = menuItem.getName();
        String xmlId = menuItem.getXmlId();
        if (StringUtils.isBlank((CharSequence)xmlId)) {
            if (this.isVisited(MenuItem.class, name)) {
                this.log.error("duplicate action menu without 'id': {}", (Object)name);
                return;
            }
        } else if (this.isVisited(MenuItem.class, xmlId)) {
            return;
        }
        this.log.debug("Loading action menu: {}", (Object)name);
        MetaActionMenu entity = this.actionMenus.findByID(xmlId);
        MetaActionMenu other = this.actionMenus.findByName(name);
        if (entity == null) {
            entity = (MetaActionMenu)this.actionMenus.all().filter("self.name = ? AND self.module = ?", name, module.getName()).fetchOne();
        }
        if (entity == null) {
            entity = new MetaActionMenu(name);
            entity.setXmlId(xmlId);
        }
        if (other == entity) {
            other = null;
        }
        if (entity.getId() == null && other != null && !Objects.equal((Object)xmlId, (Object)other.getXmlId())) {
            entity.setPriority(other.getPriority() + 1);
        }
        if (entity.getId() != null && !update) {
            return;
        }
        entity.setTitle(menuItem.getTitle());
        entity.setModule(module.getName());
        entity.setCategory(menuItem.getCategory());
        if (menuItem.getOrder() != null) {
            entity.setOrder(menuItem.getOrder());
        }
        entity = this.actionMenus.save(entity);
        if (!Strings.isNullOrEmpty((String)menuItem.getParent())) {
            MetaActionMenu parent = this.actionMenus.findByName(menuItem.getParent());
            if (parent == null) {
                this.log.debug("Unresolved parent: {}", (Object)menuItem.getParent());
                this.setUnresolved(MetaActionMenu.class, menuItem.getParent(), entity.getId());
            } else {
                entity.setParent(parent);
            }
        }
        if (!StringUtils.isBlank((CharSequence)menuItem.getAction())) {
            MetaAction action = this.actions.findByName(menuItem.getAction());
            if (action == null) {
                this.log.debug("Unresolved action: {}", (Object)menuItem.getAction());
                this.setUnresolved(MetaActionMenu.class, menuItem.getAction(), entity.getId());
            } else {
                entity.setAction(action);
            }
        }
        Long entityId = entity.getId();
        this.addResolveTask(MetaActionMenu.class, name, entityId, this::resolveParentOnActionMenu);
    }

    private void resolveParentOnActionMenu(Long actionMenuId, Long parentActionMenuId) {
        MetaActionMenu pending = (MetaActionMenu)this.actionMenus.find(actionMenuId);
        this.log.debug("Resolved action menu: {}", (Object)pending.getName());
        MetaActionMenu metaActionMenuEntity = (MetaActionMenu)this.actionMenus.find(parentActionMenuId);
        pending.setParent(metaActionMenuEntity);
    }

    private void importDefault(Module module) {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : ModelLoader.findEntities(module)) {
            Class<?> klass = JPA.model(name);
            if (klass == null) continue;
            names.add(klass.getName());
        }
        if (names.isEmpty()) {
            return;
        }
        TypedQuery query = JPA.em().createQuery("SELECT s.model FROM MetaView s", String.class);
        List found = query.getResultList();
        for (String name : names) {
            if (found.contains(name)) continue;
            Class<?> klass = JPA.model(name);
            File out = FileUtils.getFile((File)outputDir, (String)"views", (String[])new String[]{klass.getSimpleName() + ".xml"});
            String xml = this.createDefaults(module, klass);
            try {
                this.log.debug("Creating default views: {}", (Object)out);
                Files.createParentDirs((File)out);
                Files.asCharSink((File)out, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)xml);
            }
            catch (IOException e) {
                this.log.error("Unable to create: {}", (Object)out);
            }
        }
    }

    private String createDefaults(Module module, Class<?> klass) {
        List<AbstractView> views = this.createDefaults(klass);
        for (AbstractView view : views) {
            this.importView(view, module, false, null, 10);
        }
        return XMLViews.toXml(views, false);
    }

    List<AbstractView> createDefaults(Class<?> klass) {
        ArrayList<AbstractView> all = new ArrayList<AbstractView>();
        FormView formView = new FormView();
        GridView gridView = new GridView();
        Inflector inflector = Inflector.getInstance();
        String viewName = inflector.underscore(klass.getSimpleName());
        String viewTitle = klass.getSimpleName();
        viewName = inflector.dasherize(viewName);
        viewTitle = inflector.humanize(viewTitle);
        formView.setName(viewName + "-form");
        gridView.setName(viewName + "-grid");
        formView.setModel(klass.getName());
        gridView.setModel(klass.getName());
        formView.setTitle(viewTitle);
        gridView.setTitle(inflector.pluralize(viewTitle));
        ArrayList<AbstractWidget> formItems = new ArrayList<AbstractWidget>();
        ArrayList<AbstractWidget> gridItems = new ArrayList<AbstractWidget>();
        ArrayList<PanelRelated> related = new ArrayList<PanelRelated>();
        Mapper mapper = Mapper.of(klass);
        List fields = Lists.reverse(this.fieldNames(klass));
        for (String n : fields) {
            Property p = mapper.getProperty(n);
            if (p == null || p.isPrimary() || p.isVersion()) continue;
            if (p.isCollection()) {
                if (p.getTargetName() == null) continue;
                PanelRelated panel = new PanelRelated();
                ArrayList<AbstractWidget> items = new ArrayList<AbstractWidget>();
                PanelField item = new PanelField();
                item.setName(p.getTargetName());
                items.add(item);
                panel.setName(p.getName());
                panel.setTarget(p.getTarget().getName());
                panel.setItems(items);
                related.add(panel);
                continue;
            }
            PanelField formItem = new PanelField();
            com.axelor.meta.schema.views.Field gridItem = new com.axelor.meta.schema.views.Field();
            formItem.setName(p.getName());
            gridItem.setName(p.getName());
            formItems.add(formItem);
            gridItems.add(gridItem);
        }
        Panel overview = new Panel();
        overview.setTitle("Overview");
        overview.setItems(formItems);
        formItems = new ArrayList();
        formItems.add(overview);
        formItems.addAll(related);
        formView.setItems(formItems);
        gridView.setItems(gridItems);
        all.add(gridView);
        all.add(formView);
        return all;
    }

    private List<String> fieldNames(Class<?> klass) {
        ArrayList<String> result = new ArrayList<String>();
        for (Field field : klass.getDeclaredFields()) {
            if (field.getName().matches("id|version|selected|created(By|On)|updated(By|On)")) continue;
            result.add(field.getName());
        }
        if (klass.getSuperclass() != Object.class) {
            result.addAll(this.fieldNames(klass.getSuperclass()));
        }
        return Lists.reverse(result);
    }
}

