/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.db.JPA;
import com.axelor.event.Observes;
import com.axelor.events.FeatureChanged;
import com.axelor.events.ModuleChanged;
import com.axelor.events.PostRequest;
import com.axelor.events.PreRequest;
import com.axelor.events.qualifiers.EntityType;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.repo.MetaViewRepository;
import com.axelor.meta.loader.XMLViews;
import com.axelor.rpc.RequestUtils;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;

@Singleton
public class ViewObserver {
    private final MetaViewRepository metaViewRepo;
    private final XMLViews.FinalViewGenerator finalViewGenerator;
    private final Set<String> toRegenerate = new HashSet<String>();

    @Inject
    ViewObserver(MetaViewRepository metaViewRepo, XMLViews.FinalViewGenerator finalViewGenerator) {
        this.metaViewRepo = metaViewRepo;
        this.finalViewGenerator = finalViewGenerator;
    }

    void onModuleChanged(@Observes ModuleChanged event) {
        this.finalViewGenerator.generate(this.metaViewRepo.findByDependentModule(event.getModuleName()));
    }

    void onFeatureChanged(@Observes FeatureChanged event) {
        this.finalViewGenerator.generate(this.metaViewRepo.findByDependentFeature(event.getFeatureName()));
    }

    void onPostSave(@Observes @Named(value="save") @EntityType(value=MetaView.class) PostRequest event) {
        RequestUtils.processResponse(event.getResponse(), values -> {
            MetaView view = JPA.edit(MetaView.class, values);
            if (!Boolean.TRUE.equals(view.getComputed())) {
                this.finalViewGenerator.generate(Collections.singletonList(view.getName()), true);
            }
        });
    }

    void onPreRemove(@Observes @Named(value="remove") @EntityType(value=MetaView.class) PreRequest event) {
        RequestUtils.processRequest(event.getRequest(), values -> {
            MetaView view = JPA.edit(MetaView.class, values);
            String name = view.getName();
            this.toRegenerate.add(name);
        });
    }

    void onPostRemove(@Observes @Named(value="remove") @EntityType(value=MetaView.class) PostRequest event) {
        try {
            this.finalViewGenerator.generate(this.toRegenerate, true);
        }
        finally {
            this.toRegenerate.clear();
        }
    }
}

