/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.loader;

import com.axelor.common.reflections.Reflections;
import com.axelor.i18n.I18nBundle;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaStore;
import com.axelor.meta.loader.ModuleManager;
import com.axelor.meta.loader.ViewLoader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ViewWatcher {
    private static final Logger log = LoggerFactory.getLogger(ViewWatcher.class);
    private static ViewWatcher instance;
    private static ModuleManager moduleManager;
    private static Set<String> moduleNames;
    private static String appName;
    private WatchService watcher;
    private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private final List<ViewChangeEvent> pending = new ArrayList<ViewChangeEvent>();
    private static final long UPDATE_DELAY = 200L;
    private static final Pattern moduleNamePattern;
    private Set<String> pendingModules;
    private Set<Path> pendingPaths;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> scheduledFuture;
    private Thread runner;
    private boolean running;
    private BiConsumer<WatchEvent.Kind<?>, Path> watchEventHandler;

    private ViewWatcher() {
    }

    public static ViewWatcher getInstance() {
        if (instance == null) {
            instance = new ViewWatcher();
            instance.start();
            moduleManager = Beans.get(ModuleManager.class);
            moduleManager.setLoadData(false);
            moduleNames = new HashSet<String>();
            ModuleManager.getAll().stream().forEach(module -> {
                String name = module.getName();
                moduleNames.add(name);
                if (module.isApplication()) {
                    appName = name;
                }
            });
        }
        return instance;
    }

    static synchronized void process() {
        ViewWatcher watcher = ViewWatcher.getInstance();
        if (watcher.pending.isEmpty()) {
            return;
        }
        ViewLoader loader = Beans.get(ViewLoader.class);
        try {
            watcher.pending.forEach(event -> {
                if (event.isDelete()) {
                    log.warn("File deleted: {}", (Object)event.getFile());
                } else {
                    log.info("Updating views from: {}", (Object)event.getFile());
                    try {
                        loader.updateFrom(event.getFile(), event.getModule());
                    }
                    catch (Exception e) {
                        log.error("Unable to update views from: {}", (Object)event.getFile(), (Object)e);
                    }
                }
            });
        }
        finally {
            watcher.pending.clear();
        }
    }

    private synchronized void addPending(ViewChangeEvent event) {
        if (this.pending.contains(event)) {
            this.pending.remove(event);
        }
        this.pending.add(0, event);
    }

    private boolean handleEvents() {
        WatchKey key;
        try {
            key = this.watcher.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        Path dir = this.keys.get(key);
        if (dir == null) {
            return false;
        }
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW) continue;
            Path file = dir.resolve((Path)event.context());
            try {
                if (!Files.isReadable(file) || Files.size(file) <= 0L) continue;
                this.watchEventHandler.accept(kind, file);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        boolean valid = key.reset();
        if (!valid) {
            this.keys.remove(key);
            if (this.keys.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private void handleAgent(WatchEvent.Kind<?> kind, Path path) {
        Path modulePath = path.resolve(Paths.get("..", "..", "..", "..", "..")).normalize();
        this.addPending(new ViewChangeEvent(kind, path, modulePath.toFile().getName()));
    }

    private void handleJarAndBin(WatchEvent.Kind<?> kind, Path path) {
        if (kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_MODIFY) {
            return;
        }
        if (path.toString().endsWith(".jar")) {
            this.handleJar(kind, path);
        } else {
            this.handleBin(kind, path);
        }
    }

    private void handleJar(WatchEvent.Kind<?> kind, Path path) {
        String fileName = path.getFileName().toString();
        Matcher moduleNameMatcher = moduleNamePattern.matcher(fileName);
        if (!moduleNameMatcher.find()) {
            log.error("Cannot identify module name: {}", (Object)path);
            return;
        }
        String moduleName = moduleNameMatcher.group(1);
        this.addPending(moduleName, path);
    }

    private void handleBin(WatchEvent.Kind<?> kind, Path path) {
        Path modulePath = path.resolve(Paths.get("..", "..", "..", "..")).normalize();
        String moduleName = modulePath.toFile().getName();
        this.addPending(moduleName, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPending(String moduleName, Path path) {
        Set<String> set = this.pendingModules;
        synchronized (set) {
            if (this.scheduledFuture != null && !this.scheduledFuture.cancel(false)) {
                this.wait(this.scheduledFuture);
            }
            String name = moduleNames.contains(moduleName) ? moduleName : appName;
            this.pendingModules.add(name);
            this.pendingPaths.add(path);
            this.scheduledFuture = this.scheduler.schedule(() -> {
                Set<String> set = this.pendingModules;
                synchronized (set) {
                    try {
                        moduleManager.update(this.pendingModules, this.pendingPaths);
                        MetaStore.clear();
                        I18nBundle.invalidate();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        this.pendingModules.clear();
                        this.pendingPaths.clear();
                        this.scheduledFuture = null;
                    }
                }
            }, 200L, TimeUnit.MILLISECONDS);
        }
    }

    private void wait(Future<?> future) {
        do {
            try {
                future.get(10L, TimeUnit.MINUTES);
                return;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
            catch (TimeoutException e) {
                log.warn("Furure {} is taking a long time to complete.", future);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (!Thread.currentThread().isInterrupted());
    }

    private synchronized void registerAll() throws Exception {
        Pattern pattern = Pattern.compile(".*propertiesFilePath=([^,]+).*");
        Set<Path> paths = ManagementFactory.getRuntimeMXBean().getInputArguments().stream().filter(s -> s.startsWith("-javaagent")).map(s -> pattern.matcher((CharSequence)s)).filter(m -> m.matches()).map(m -> m.group(1).trim()).map(x$0 -> Paths.get(x$0, new String[0])).flatMap(file -> {
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream(file.toFile());){
                props.load(is);
            }
            catch (IOException e) {
                log.error("unable to read: {}", file, (Object)e);
                throw new UncheckedIOException(e);
            }
            String resources = props.getProperty("watchResources", "");
            return Stream.of(resources.split(","));
        }).map(String::trim).map(x$0 -> Paths.get(x$0, new String[0])).map(p -> p.resolve("views")).filter(p -> p.toFile().isDirectory()).collect(Collectors.toSet());
        if (!paths.isEmpty()) {
            this.watchEventHandler = this::handleAgent;
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Optional<URL> rootResourceOpt = Optional.ofNullable(classLoader.getResource(""));
            rootResourceOpt.ifPresent(rootResource -> {
                Path libPath = Paths.get(ViewWatcher.toURI(rootResource)).resolve(Paths.get("..", "lib")).normalize();
                if (libPath.toFile().isDirectory()) {
                    paths.add(libPath);
                }
            });
            Reflections.findResources().byName("(domains|i18n|views)/(.*?)\\.(xml|csv)$").find().parallelStream().filter(url -> url.getPath().startsWith("/")).map(url -> Paths.get(ViewWatcher.toURI(url)).resolve("..").normalize()).distinct().forEach(paths::add);
            if (!paths.isEmpty()) {
                this.watchEventHandler = this::handleJarAndBin;
            }
        }
        if (paths.isEmpty()) {
            return;
        }
        if (this.watcher == null) {
            this.watcher = FileSystems.getDefault().newWatchService();
        }
        log.info("Starting view watch...");
        paths.forEach(p -> {
            try {
                this.keys.put(p.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY), (Path)p);
                log.info("Watching: {}", p);
            }
            catch (IOException e) {
                log.warn("Unable to watch: {}", p);
            }
        });
    }

    private static boolean isEnabled() {
        return Boolean.parseBoolean(System.getProperty("axelor.view.watch")) || ViewWatcher.isDebug();
    }

    private static boolean isDebug() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("-agentlib:jdwp");
    }

    public void start() {
        if (this.running || !ViewWatcher.isEnabled()) {
            return;
        }
        try {
            this.registerAll();
        }
        catch (Exception e) {
            log.error("Unable to start view watch.", (Throwable)e);
            return;
        }
        if (this.keys.isEmpty()) {
            return;
        }
        this.pendingModules = new HashSet<String>();
        this.pendingPaths = new HashSet<Path>();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.runner = new Thread(() -> {
            while (this.running && this.handleEvents()) {
            }
        });
        this.runner.setDaemon(true);
        this.runner.start();
        this.running = true;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            log.info("Stopping view watch....");
            this.keys.keySet().forEach(WatchKey::cancel);
            this.keys.clear();
            this.shutdownScheduler();
        }
    }

    private void shutdownScheduler() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(1L, TimeUnit.MINUTES)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        moduleNamePattern = Pattern.compile("(?:[a-z0-9_]+(?:\\.[a-z0-9_]+)+-)?(\\w*(?:-[a-z]\\w*)*)");
    }

    static final class ViewChangeEvent {
        private final WatchEvent.Kind<?> kind;
        private final Path file;
        private final String module;

        public ViewChangeEvent(WatchEvent.Kind<?> kind, Path file, String module) {
            this.kind = kind;
            this.file = file;
            this.module = module;
        }

        public boolean isCreate() {
            return this.kind == StandardWatchEventKinds.ENTRY_CREATE;
        }

        public boolean isDelete() {
            return this.kind == StandardWatchEventKinds.ENTRY_DELETE;
        }

        public boolean isModify() {
            return this.kind == StandardWatchEventKinds.ENTRY_MODIFY;
        }

        public WatchEvent.Kind<?> getKind() {
            return this.kind;
        }

        public Path getFile() {
            return this.file;
        }

        public String getModule() {
            return this.module;
        }

        public int hashCode() {
            return Objects.hash(0, this.file);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ViewChangeEvent)) {
                return false;
            }
            ViewChangeEvent other = (ViewChangeEvent)obj;
            return this.file.equals(other.file);
        }

        public String toString() {
            return "[" + this.kind + ", " + this.file + "]";
        }
    }
}

