/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.common.StringUtils;
import com.axelor.events.PostAction;
import com.axelor.meta.ActionHandler;
import com.axelor.rpc.ActionResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType(name="AbstractAction")
public abstract class Action {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    @XmlAttribute(name="id")
    private String xmlId;
    @XmlTransient
    @JsonProperty
    private Long actionId;
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String model;
    @XmlAttribute(name="if-module")
    private String moduleToCheck;

    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    public Long getActionId() {
        return this.actionId;
    }

    public void setActionId(Long actionId) {
        this.actionId = actionId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getModuleToCheck() {
        return this.moduleToCheck;
    }

    public void setModuleToCheck(String moduleToCheck) {
        this.moduleToCheck = moduleToCheck;
    }

    public Object execute(ActionHandler handler) {
        Object result;
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            result = this.evaluate(handler);
        } else {
            handler.firePreEvent(this.getName());
            Object value = this.evaluate(handler);
            PostAction event = handler.firePostEvent(this.getName(), value);
            result = event.getResult();
        }
        return result;
    }

    public Object wrap(ActionHandler handler) {
        Object result = this.execute(handler);
        return result instanceof ActionResponse ? result : this.wrapper(result);
    }

    protected Object wrapper(Object value) {
        return value;
    }

    protected abstract Object evaluate(ActionHandler var1);

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.getName()).toString();
    }

    static String toExpression(String expression, boolean quote) {
        Pattern pattern = Pattern.compile("^(#\\{|(eval|select|action):)");
        if (expression != null && !pattern.matcher(expression).find()) {
            expression = "eval: " + (quote ? "\"\"\"" + expression + "\"\"\"" : expression);
        }
        return expression;
    }

    static boolean test(ActionHandler handler, String expression) {
        if (Strings.isNullOrEmpty((String)expression)) {
            return true;
        }
        if ("true".equals(expression)) {
            return true;
        }
        if ("false".equals(expression)) {
            return false;
        }
        Object result = handler.evaluate(Action.toExpression(expression, false));
        if (result == null) {
            return false;
        }
        if (result instanceof Number && result.equals(0)) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return true;
    }

    @XmlType
    public static abstract class Element {
        @XmlAttribute(name="if")
        private String condition;
        @XmlAttribute
        private String name;
        @XmlAttribute(name="expr")
        private String expression;

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        boolean test(ActionHandler handler) {
            return Action.test(handler, this.getCondition());
        }
    }
}

