/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.meta.ActionHandler;
import com.axelor.meta.schema.actions.Action;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class ActionAttrs
extends Action {
    @XmlElement(name="attribute", type=Attribute.class)
    private List<Attribute> attributes;

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    protected Object evaluate(ActionHandler handler) {
        HashMap map = Maps.newHashMap();
        for (Attribute attribute : this.attributes) {
            if (!attribute.test(handler) || Strings.isNullOrEmpty((String)attribute.getFieldName())) continue;
            for (String field : attribute.fieldName.split(",")) {
                if (Strings.isNullOrEmpty((String)field)) continue;
                Map attrs = (Map)map.get(field = field.trim());
                if (attrs == null) {
                    attrs = Maps.newHashMap();
                    map.put(field, attrs);
                }
                String name = attribute.getName();
                Object value = null;
                value = name.matches("readonly|required|recommend|hidden|collapse") ? Boolean.valueOf(Action.test(handler, attribute.getExpression())) : handler.evaluate(attribute.getExpression());
                attrs.put(attribute.getName(), value);
            }
        }
        return map;
    }

    @Override
    protected Object wrapper(Object value) {
        if (value == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("attrs", value);
        return result;
    }

    @XmlType
    public static class Attribute
    extends Action.Element {
        @XmlAttribute(name="for")
        private String fieldName;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }
    }
}

