/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.app.AppSettings;
import com.axelor.common.FileUtils;
import com.axelor.common.ResourceUtils;
import com.axelor.i18n.I18n;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.schema.actions.Action;
import com.axelor.text.GroovyTemplates;
import com.axelor.text.StringTemplates;
import com.axelor.text.Templates;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class ActionExport
extends Action {
    private static final String DEFAULT_EXPORT_DIR = "{java.io.tmpdir}/axelor/data-export";
    private static final String DEFAULT_DIR = "${date}/${name}";
    @XmlAttribute(name="output")
    private String output;
    @XmlAttribute(name="download")
    private Boolean download;
    @XmlElement(name="export")
    private List<Export> exports;

    public String getOutput() {
        return this.output;
    }

    public Boolean getDownload() {
        return this.download;
    }

    public List<Export> getExports() {
        return this.exports;
    }

    public static File getExportPath() {
        String path = AppSettings.get().getPath("data.export.dir", DEFAULT_EXPORT_DIR);
        return new File(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExport(String dir, Export export, ActionHandler handler) throws IOException {
        String templatePath = handler.evaluate(export.template).toString();
        try (Reader reader = null;){
            String name;
            File template = new File(templatePath);
            if (template.isFile()) {
                reader = new FileReader(template);
            }
            if (reader == null) {
                InputStream is = ResourceUtils.getResourceStream((String)templatePath);
                if (is == null) {
                    throw new FileNotFoundException("No such template: " + templatePath);
                }
                reader = new InputStreamReader(is);
            }
            if ((name = export.getName()).indexOf("$") > -1 || name.startsWith("#{") && name.endsWith("}")) {
                name = handler.evaluate(ActionExport.toExpression(name, true)).toString();
            }
            this.log.info("export {} as {}", (Object)templatePath, (Object)name);
            Templates engine = new StringTemplates('$', '$');
            if ("groovy".equals(export.engine)) {
                engine = new GroovyTemplates();
            }
            File output = ActionExport.getExportPath();
            output = FileUtils.getFile((File)output, (String)dir, (String[])new String[]{name});
            String contents = null;
            contents = handler.template(engine, reader);
            Files.createParentDirs((File)output);
            Files.asCharSink((File)output, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)contents);
            this.log.info("file saved: {}", (Object)output);
            String string = FileUtils.getFile((String)dir, (String[])new String[]{name}).toString();
            return string;
        }
    }

    @Override
    public Object evaluate(ActionHandler handler) {
        this.log.info("action-export: {}", (Object)this.getName());
        String dir = this.output == null ? DEFAULT_DIR : this.output;
        dir = dir.replace("${name}", this.getName()).replace("${date}", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).replace("${time}", LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        dir = handler.evaluate(dir).toString();
        for (Export export : this.exports) {
            if (!export.test(handler)) continue;
            HashMap<String, String> result = new HashMap<String, String>();
            try {
                String file = this.doExport(dir, export, handler);
                if (this.getDownload() == Boolean.TRUE) {
                    result.put("exportFile", file);
                    result.put("notify", I18n.get("Export complete."));
                    return result;
                }
                result.put("notify", I18n.get("Export complete."));
                return result;
            }
            catch (Exception e) {
                this.log.error("error while exporting: ", (Throwable)e);
                result.put("error", e.getMessage());
                return result;
            }
        }
        return null;
    }

    @XmlType
    public static class Export
    extends Action.Element {
        @XmlAttribute
        private String template;
        @XmlAttribute
        private String engine;
        @XmlAttribute(name="processor")
        private String processor;

        public String getTemplate() {
            return this.template;
        }

        public String getEngine() {
            return this.engine;
        }

        public String getProcessor() {
            return this.processor;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.getName()).add("template", (Object)this.template).toString();
        }
    }
}

