/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.common.ObjectUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.i18n.I18n;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.MetaStore;
import com.axelor.meta.loader.XMLViews;
import com.axelor.meta.schema.actions.Action;
import com.axelor.meta.schema.actions.ActionCondition;
import com.axelor.meta.schema.actions.ActionMethod;
import com.axelor.meta.schema.actions.ActionReport;
import com.axelor.meta.schema.actions.ActionResumable;
import com.axelor.meta.schema.actions.ActionValidate;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.rpc.ContextEntity;
import com.axelor.rpc.Response;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class ActionGroup
extends ActionResumable {
    @XmlElement(name="action")
    private List<ActionItem> actions;

    public List<ActionItem> getActions() {
        return this.actions;
    }

    public void setActions(List<ActionItem> actions) {
        this.actions = actions;
    }

    public void addAction(String name) {
        if (this.actions == null) {
            this.actions = Lists.newArrayList();
        }
        ActionItem item = new ActionItem();
        item.setName(name);
        this.actions.add(item);
    }

    public void validate() throws IllegalStateException {
        if (this.actions == null || this.actions.isEmpty()) {
            return;
        }
        int index = 0;
        for (ActionItem item : this.actions) {
            Action action = this.findAction(item.getName());
            if (!(action instanceof ActionReport) || ++index >= this.actions.size()) continue;
            String message = String.format(I18n.get("Invalid use of action-record: %s, must be the last action."), action.getName());
            throw new IllegalStateException(message);
        }
    }

    private String getPending(int index, String ... prepend) {
        ArrayList pending = Lists.newArrayList((Object[])prepend);
        if (index + 1 < this.actions.size()) {
            String name = this.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                for (int i = index + 1; i < this.actions.size(); ++i) {
                    pending.add(this.actions.get(i).getName());
                }
            } else {
                pending.add(name + "[" + (index + 1) + "]");
            }
        }
        return Joiner.on((String)",").skipNulls().join((Iterable)pending);
    }

    private Action findAction(String name) {
        if (name == null || "".equals(name.trim())) {
            return null;
        }
        String actionName = name.trim();
        if (actionName.contains(":")) {
            String[] parts = name.split("\\:", 3);
            if (XMLViews.isViewType(parts[0])) {
                ActionView actionView = new ActionView();
                ActionView.View view = new ActionView.View();
                AbstractView xml = XMLViews.findView(parts[1], parts[0]);
                view.setType(parts[0]);
                view.setName(parts[1]);
                actionView.setViews((List<ActionView.View>)ImmutableList.of((Object)view));
                actionView.setName(actionName);
                if (parts.length == 3) {
                    Class<?> model;
                    try {
                        model = Class.forName(parts[2]);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException(e);
                    }
                    actionView.setModel(model.getName());
                    xml = XMLViews.findView(parts[1], parts[0], model.getName());
                }
                if (xml != null) {
                    actionView.setTitle(xml.getTitle());
                    if (actionView.getModel() == null) {
                        actionView.setModel(xml.getModel());
                    }
                }
                return actionView;
            }
            ActionMethod.Call method = new ActionMethod.Call();
            method.setController(parts[0]);
            method.setMethod(parts[1]);
            ActionMethod action = new ActionMethod();
            action.setCall(method);
            action.setName(actionName);
            return action;
        }
        if (actionName.indexOf("[") > -1 && actionName.endsWith("]")) {
            String idx = actionName.substring(actionName.lastIndexOf(91) + 1, actionName.lastIndexOf(93));
            actionName = actionName.substring(0, actionName.lastIndexOf(91));
            int index = Integer.parseInt(idx);
            this.log.debug("continue action-validate: {}", (Object)actionName);
            this.log.debug("continue at: {}", (Object)index);
            Action action = MetaStore.getAction(actionName);
            if (action instanceof ActionResumable) {
                return ((ActionResumable)action).resumeAt(index);
            }
            return action;
        }
        return MetaStore.getAction(actionName);
    }

    @Override
    protected ActionGroup copy() {
        ActionGroup action = new ActionGroup();
        ArrayList<ActionItem> items = new ArrayList<ActionItem>(this.actions);
        action.setName(this.getName());
        action.setModel(this.getModel());
        action.setActions(items);
        return action;
    }

    @Override
    public Object evaluate(ActionHandler handler) {
        this.validate();
        ArrayList result = Lists.newArrayList();
        Iterator<ActionItem> iter = this.actions.iterator();
        if (StringUtils.notBlank((CharSequence)this.getName()) && !this.getName().endsWith("MenuTag()")) {
            this.log.debug("action-group: {}", (Object)this.getName());
        }
        for (int i = this.getIndex(); i < this.actions.size(); ++i) {
            Action.Element element = this.actions.get(i);
            String name = element.getName().trim();
            if (!name.endsWith("MenuTag()")) {
                this.log.debug("action: {}", (Object)name);
            }
            if ("save".equals(name) || "validate".equals(name) || "close".equals(name) || "new".equals(name)) {
                if (!element.test(handler)) {
                    this.log.debug("action '{}' doesn't meet the condition: {}", (Object)name, (Object)element.getCondition());
                    continue;
                }
                String pending = this.getPending(i, new String[0]);
                HashMap res = Maps.newHashMap();
                res.put(name, true);
                res.put("pending", pending);
                result.add(res);
                if (StringUtils.isBlank((CharSequence)pending)) break;
                this.log.debug("wait for '{}', pending actions: {}", (Object)name, (Object)pending);
                break;
            }
            Action action = this.findAction(name);
            if (action == null) {
                this.log.warn("action doesn't exist or module dependency is not resolved: {}", (Object)name);
                continue;
            }
            if (!element.test(handler)) {
                this.log.debug("action '{}' doesn't meet the condition: {}", (Object)element.getName(), (Object)element.getCondition());
                continue;
            }
            Object value = action.wrap(handler);
            if (value instanceof Response) {
                Response res = (Response)value;
                if (res.getStatus() != Response.STATUS_SUCCESS || this.actions.size() == 1) {
                    return res;
                }
                value = res.getItem(0);
                if (!ObjectUtils.isEmpty(res.getErrors())) {
                    HashMap resValues = Maps.newHashMap();
                    resValues.put("data", res.getItem(0));
                    resValues.put("errors", res.getErrors());
                    if (this.hasErrors(resValues).booleanValue()) {
                        result.add(resValues);
                        break;
                    }
                    value = resValues;
                }
            }
            if (value == null) continue;
            if (value instanceof Map) {
                this.updateContext(handler, (Map)value);
            }
            if (action instanceof ActionGroup && value instanceof Collection) {
                result.addAll((Collection)value);
            } else {
                result.add(value);
            }
            if (value instanceof Map && Objects.equal((Object)Boolean.TRUE, ((Map)value).get("reload"))) {
                String pending = this.getPending(i, new String[0]);
                this.log.debug("wait for 'reload', pending actions: {}", (Object)pending);
                ((Map)value).put("pending", pending);
                break;
            }
            if (action instanceof ActionValidate && value instanceof Map) {
                String validate = (String)((Map)value).get("pending");
                String pending = this.getPending(i, validate);
                this.log.debug("wait for validation: {}, {}", (Object)name, value);
                this.log.debug("pending actions: {}", (Object)pending);
                ((Map)value).put("pending", pending);
                break;
            }
            if (action instanceof ActionCondition && (Objects.equal((Object)value, (Object)Boolean.FALSE) || value instanceof Map && this.hasErrors((Map)value).booleanValue())) break;
            if (!(action instanceof ActionGroup) && !(action instanceof ActionMethod) || result.isEmpty() || !iter.hasNext()) continue;
            Map last = null;
            try {
                last = (Map)result.get(result.size() - 1);
            }
            catch (ClassCastException pending) {
                // empty catch block
            }
            if (last == null || !Objects.equal((Object)Boolean.TRUE, last.get("reload")) && !last.containsKey("info") && !last.containsKey("alert") && !last.containsKey("error") && !last.containsKey("save") && !last.containsKey("validate") && !last.containsKey("close") && !last.containsKey("new")) continue;
            String previous = (String)last.get("pending");
            String pending = this.getPending(i, previous);
            last.put("pending", pending);
            this.log.debug("wait for group: {}", (Object)action.getName());
            this.log.debug("pending actions: {}", (Object)pending);
            break;
        }
        return result;
    }

    private Boolean hasErrors(Map<String, Object> value) {
        if (ObjectUtils.isEmpty(value)) {
            return Boolean.FALSE;
        }
        Object errors = value.get("errors");
        if (errors instanceof Map) {
            for (Object key : ((Map)errors).keySet()) {
                String error = (String)((Map)errors).get(key);
                if (StringUtils.isEmpty((CharSequence)error)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private void updateContext(ActionHandler handler, Map<String, Object> value) {
        if (value == null || value instanceof ContextEntity) {
            return;
        }
        Object values = value.get("values");
        Map<Object, Object> map = Maps.newHashMap();
        if (values instanceof ContextEntity) {
            map = ((ContextEntity)values).getContextMap();
        } else if (values instanceof Model) {
            map = Mapper.toMap(value);
        } else if (values instanceof Map) {
            map = Maps.newHashMap((Map)((Map)values));
        }
        values = value.get("attrs");
        if (values instanceof Map) {
            for (Object key : ((Map)values).keySet()) {
                String name = key.toString();
                Map attrs = (Map)((Map)values).get(key);
                if (name.indexOf(36) == 0) {
                    name = name.substring(1);
                }
                if (attrs.containsKey("value")) {
                    map.put(name, attrs.get("value"));
                }
                if (!attrs.containsKey("value:set")) continue;
                map.put(name, attrs.get("value:set"));
            }
        }
        try {
            handler.getContext().putAll((Map<? extends String, ? extends Object>)map);
        }
        catch (IllegalArgumentException e) {
            handler.getContext().putAll((Map<? extends String, ? extends Object>)Mapper.toMap(Mapper.toBean(handler.getContext().getContextClass(), (Map<String, Object>)map)));
        }
    }

    public static class ActionItem
    extends Action.Element {
    }
}

