/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.data.ImportException;
import com.axelor.data.ImportTask;
import com.axelor.data.Listener;
import com.axelor.data.xml.XMLImporter;
import com.axelor.db.Model;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.MetaStore;
import com.axelor.meta.schema.actions.Action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class ActionImport
extends Action {
    @XmlAttribute
    private String config;
    @XmlElement(name="import")
    private List<Import> imports;

    public String getConfig() {
        return this.config;
    }

    public List<Import> getImports() {
        return this.imports;
    }

    private List<Model> doImport(XMLImporter importer, final String fileName, Object data) {
        if (!(data instanceof String)) {
            this.log.debug("stream type not supported: " + data.getClass());
            return null;
        }
        this.log.info("action-import: " + fileName);
        final StringReader reader = new StringReader((String)data);
        HashMultimap mapping = HashMultimap.create();
        final ArrayList records = Lists.newArrayList();
        mapping.put((Object)fileName, (Object)reader);
        importer.addListener(new Listener(){

            @Override
            public void imported(Model bean) {
                ActionImport.this.log.info("action-import (record): {}(id={})", (Object)bean.getClass().getSimpleName(), (Object)bean.getId());
                records.add(bean);
            }

            @Override
            public void imported(Integer total, Integer success) {
            }

            @Override
            public void handle(Model bean, Exception e) {
            }
        });
        importer.setCanClear(false);
        importer.run(new ImportTask(){

            @Override
            public void configure() throws IOException {
                this.input(fileName, reader);
            }

            @Override
            public boolean handle(ImportException e) {
                ActionImport.this.log.error("error:" + e);
                e.printStackTrace();
                return true;
            }
        });
        this.log.info("action-import (count): " + records.size());
        return records;
    }

    @Override
    public Object evaluate(ActionHandler handler) {
        HashMap result = Maps.newHashMap();
        Object configName = handler.evaluate(this.config);
        if (configName == null) {
            this.log.debug("No such config file: " + this.config);
            return result;
        }
        this.log.info("action-import (config): " + configName.toString());
        XMLImporter importer = new XMLImporter(configName.toString());
        importer.setContext(handler.getContext());
        int count = 0;
        for (Import stream : this.getImports()) {
            this.log.info("action-import (stream, provider): " + stream.getFile() + ", " + stream.getProvider());
            Action action = MetaStore.getAction(stream.getProvider());
            if (action == null) {
                this.log.debug("No such action: " + stream.getProvider());
                continue;
            }
            ArrayList records = Lists.newArrayList();
            Object data = action.evaluate(handler);
            if (data instanceof Collection) {
                for (Object item : (Collection)data) {
                    if (!(item instanceof String)) continue;
                    this.log.info("action-import (xml stream)");
                    List<Model> imported = this.doImport(importer, stream.getFile(), item);
                    if (imported == null) continue;
                    records.addAll(imported);
                }
            } else {
                this.log.info("action-import (object stream)");
                List<Model> imported = this.doImport(importer, stream.getFile(), data);
                if (imported != null) {
                    records.addAll(imported);
                }
            }
            count += records.size();
            result.put(stream.name == null ? stream.getFile() : stream.name, records);
        }
        this.log.info("action-import (total): " + count);
        return result;
    }

    @Override
    protected Object wrapper(Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("values", value);
        return result;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.getName()).toString();
    }

    @XmlType
    public static class Import {
        @XmlAttribute
        private String file;
        @XmlAttribute
        private String provider;
        @XmlAttribute
        private String name;

        public String getFile() {
            return this.file;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("file", (Object)this.file).add("provider", (Object)this.provider).toString();
        }
    }
}

