/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.schema.actions.Action;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class ActionRecord
extends Action {
    @XmlAttribute
    private String search;
    @XmlAttribute
    private String ref;
    @XmlAttribute(name="copy")
    private Boolean canCopy;
    @XmlAttribute(name="saveIf")
    private String saveIf;
    @XmlElement(name="field")
    private List<RecordField> fields;

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Boolean getCanCopy() {
        return this.canCopy;
    }

    public void setCanCopy(Boolean canCopy) {
        this.canCopy = canCopy;
    }

    public String getSaveIf() {
        return this.saveIf;
    }

    public void setSaveIf(String saveIf) {
        this.saveIf = saveIf;
    }

    public List<RecordField> getFields() {
        return this.fields;
    }

    public void setFields(List<RecordField> field) {
        this.fields = field;
    }

    private Class<?> findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object wrap(ActionHandler handler) {
        HashMap<String, Object> result;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            result = this.evaluate(handler, map);
        } else {
            handler.firePreEvent(this.getName());
            result = this.evaluate(handler, map);
            handler.firePostEvent(this.getName(), result instanceof ActionResponse ? result : map);
        }
        return result == null || result instanceof ActionResponse ? result : this.wrapper(map);
    }

    @Override
    protected Object evaluate(ActionHandler handler) {
        return this.evaluate(handler, new HashMap<String, Object>());
    }

    @Override
    protected Object wrapper(Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("values", value);
        return result;
    }

    private Object evaluate(ActionHandler handler, final Map<String, Object> map) {
        Object[] result;
        Object result2;
        Class<?> entityClass = this.findClass(this.getModel());
        if (this.ref != null && (result2 = handler.evaluate(this.ref)) != null) {
            if (this.canCopy == Boolean.TRUE) {
                return JPA.copy((Model)result2, true);
            }
            return result2;
        }
        Mapper mapper = Mapper.of(entityClass);
        Object target = Mapper.toBean(entityClass, null);
        for (RecordField recordField : this.fields) {
            if (!recordField.test(handler) || StringUtils.isBlank((CharSequence)recordField.getName())) continue;
            for (String name : recordField.getName().split(",")) {
                name = name.trim();
                String expr = recordField.getExpression();
                Object value = expr;
                try {
                    value = handler.evaluate(expr);
                }
                catch (Exception e) {
                    this.log.error("error evaluating expression");
                    this.log.error("expression: {}", (Object)expr, (Object)e);
                    continue;
                }
                Property property = mapper.getProperty(name);
                if (property == null) {
                    map.put(name, value);
                    continue;
                }
                if (recordField.getCanCopy() == Boolean.TRUE && value instanceof Model) {
                    value = JPA.copy((Model)value, true);
                }
                try {
                    property.set(target, value);
                    if (map == null) continue;
                    map.put(property.getName(), property.get(target));
                }
                catch (Exception e) {
                    this.log.error("invalid value for field: {}", (Object)property.getName());
                    this.log.error("value: {}", value);
                }
            }
        }
        if (this.search != null && (result = handler.search(entityClass, this.search, map)) != null) {
            if (this.canCopy == Boolean.TRUE) {
                return JPA.copy((Model)result, true);
            }
            return result;
        }
        result = new Object[]{target};
        if (this.canSave(handler, (Model)target)) {
            JPA.runInTransaction(new Runnable(){

                @Override
                public void run() {
                    Model bean = JPA.save((Model)result[0]);
                    map.putAll(Resource.toMapCompact(bean));
                    result[0] = bean;
                }
            });
        }
        return result[0];
    }

    private boolean canSave(ActionHandler handler, Model bean) {
        if (bean == null || StringUtils.isBlank((CharSequence)this.saveIf)) {
            return false;
        }
        if (bean.getId() != null && bean.getVersion() == null) {
            return false;
        }
        return Action.test(handler, this.saveIf);
    }

    @XmlType
    public static class RecordField
    extends Action.Element {
        @XmlAttribute(name="copy")
        private Boolean canCopy;

        public Boolean getCanCopy() {
            return this.canCopy;
        }
    }
}

