/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.app.internal.AppFilter;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.schema.actions.Action;
import com.axelor.meta.schema.actions.ActionRecord;
import com.axelor.report.ReportGenerator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.birt.core.exception.BirtException;

public class ActionReport
extends Action {
    private static final String DEFAULT_FORMAT = "pdf";
    @XmlAttribute
    private String title;
    @XmlAttribute(name="design")
    private String designName;
    @XmlAttribute(name="output")
    private String outputName;
    @XmlAttribute
    private String format = "pdf";
    @XmlAttribute
    private Boolean attachment;
    @XmlElement(name="param")
    private List<Parameter> parameters;

    @JsonGetter(value="title")
    public String getLocalizedTitle() {
        return I18n.get(this.title);
    }

    @JsonIgnore
    public String getTitle() {
        return this.title;
    }

    public String getDesignName() {
        return this.designName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public String getFormat() {
        return this.format;
    }

    public Boolean getAttachment() {
        return this.attachment;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    private Object _evaluate(ActionHandler handler) throws IOException, BirtException {
        this.log.debug("action-report: {}", (Object)this.getName());
        HashMap<String, Object> params = new HashMap<String, Object>();
        ReportGenerator generator = Beans.get(ReportGenerator.class);
        if (this.parameters != null) {
            for (Parameter param : this.parameters) {
                if (!param.test(handler)) continue;
                params.put(param.getName(), handler.evaluate(param.getExpression()));
            }
        }
        this.log.debug("with params: {}", params);
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> klass = handler.getContext().getContextClass();
        Long id = (Long)handler.getContext().get("id");
        String outputName = this.outputName.replace("${date}", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).replace("${time}", LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss"))).replace("${name}", this.getName());
        String fileName = String.format("%s.%s", outputName, this.format);
        File output = generator.generate(this.designName, this.format, params, AppFilter.getLocale());
        result.put("report", this.getName());
        result.put("reportFile", fileName);
        result.put("reportLink", output.getName());
        result.put("reportFormat", this.format);
        if (this.attachment == Boolean.TRUE && id != null) {
            Model bean = (Model)JPA.em().find(klass, (Object)id);
            try (FileInputStream is = new FileInputStream(output);){
                result.put("attached", Beans.get(MetaFiles.class).attach(is, fileName, bean));
            }
        }
        return result;
    }

    @Override
    public Object evaluate(ActionHandler handler) {
        try {
            return this._evaluate(handler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @XmlType
    public static class Parameter
    extends ActionRecord.RecordField {
    }
}

