/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.db.JPA;
import com.axelor.inject.Beans;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.db.repo.MetaJsonRecordRepository;
import com.axelor.meta.schema.actions.Action;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.script.GroovyScriptHelper;
import com.axelor.script.NashornScriptHelper;
import com.axelor.script.ScriptHelper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.inject.persist.Transactional;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.eclipse.persistence.oxm.annotations.XmlCDATA;

public class ActionScript
extends Action {
    private static final String LANGUAGE_JS = "js";
    private static final String KEY_REQUEST = "$request";
    private static final String KEY_RESPONSE = "$response";
    private static final String KEY_JSON = "$json";
    private static final String KEY_EM = "$em";
    @JsonIgnore
    @XmlElement(name="script")
    private ActScript script;

    public ActScript getScript() {
        return this.script;
    }

    public void setScript(ActScript script) {
        this.script = script;
    }

    private ScriptHelper getScriptHelper(Bindings bindings) {
        return LANGUAGE_JS.equalsIgnoreCase(this.script.language) ? new NashornScriptHelper(bindings) : new GroovyScriptHelper(bindings);
    }

    private Object run(ActionHandler handler) {
        SimpleBindings bindings = new SimpleBindings();
        ActionRequest request = handler.getRequest();
        ActionResponse response = new ActionResponse();
        bindings.put(KEY_REQUEST, (Object)request);
        bindings.put(KEY_RESPONSE, (Object)response);
        bindings.put(KEY_JSON, (Object)Beans.get(MetaJsonRecordRepository.class));
        if (this.script.transactional == Boolean.TRUE) {
            bindings.put(KEY_EM, (Object)JPA.em());
        }
        try {
            this.getScriptHelper(bindings).eval(this.script.code.trim(), bindings);
        }
        catch (ScriptException e) {
            if ("<eval>".equals(e.getFileName())) {
                e = new ScriptException(e.getMessage().replace("<eval>", "<strong>&lt;action-script name=" + this.getName() + "&gt;</strong>"));
            }
            response.setException(e);
        }
        catch (Exception e) {
            response.setException(e);
        }
        return response;
    }

    @Override
    public Object evaluate(ActionHandler handler) {
        return this.script.transactional == Boolean.TRUE ? Beans.get(ActRunner.class).run(this, handler) : this.run(handler);
    }

    @XmlType
    public static class ActScript {
        @XmlAttribute
        private String language;
        @XmlAttribute
        private Boolean transactional;
        @XmlCDATA
        @XmlValue
        public String code;

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public Boolean getTransactional() {
            return this.transactional;
        }

        public void setTransactional(Boolean transactional) {
            this.transactional = transactional;
        }
    }

    public static class ActRunner {
        @Transactional
        public Object run(ActionScript action, ActionHandler handler) {
            return action.run(handler);
        }
    }
}

