/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.i18n.I18n;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.schema.actions.Action;
import com.axelor.meta.schema.actions.ActionRecord;
import com.axelor.rpc.ContextEntity;
import com.axelor.rpc.Resource;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"views", "params", "domain", "contexts"})
public class ActionView
extends Action {
    @XmlAttribute
    private String title;
    @XmlAttribute
    private String icon;
    @XmlAttribute
    private Boolean home;
    @XmlElement
    private String domain;
    @XmlElement(name="view")
    private List<View> views;
    @XmlElement(name="context")
    private List<Context> contexts;
    @XmlElement(name="view-param")
    private List<Param> params;

    @JsonGetter(value="title")
    public String getLocalizedTitle() {
        return I18n.get(this.title);
    }

    @JsonIgnore
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIcon() {
        return this.icon;
    }

    public Boolean getHome() {
        return this.home;
    }

    public String getDomain() {
        return this.domain;
    }

    public List<View> getViews() {
        return this.views;
    }

    public void setViews(List<View> views) {
        this.views = views;
    }

    @XmlTransient
    public Object getContext() {
        return null;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public void setParams(List<Param> params) {
        this.params = params;
    }

    @Override
    public Object evaluate(ActionHandler handler) {
        String title;
        String domain;
        Object value;
        HashMap result = Maps.newHashMap();
        HashMap context = Maps.newHashMap();
        HashMap viewParams = Maps.newHashMap();
        ArrayList items = Lists.newArrayList();
        String viewType = null;
        for (View elem : this.views) {
            if (!elem.test(handler)) continue;
            HashMap map = Maps.newHashMap();
            map.put("name", handler.evaluate(elem.getName()));
            map.put("type", elem.getType());
            if (viewType == null) {
                viewType = elem.getType();
            }
            items.add(map);
        }
        if (this.contexts != null) {
            for (Context ctx : this.contexts) {
                if (!ctx.test(handler)) continue;
                value = handler.evaluate(ctx.getExpression());
                if (ctx.getCanCopy() == Boolean.TRUE && value instanceof Model) {
                    value = JPA.copy((Model)value, true);
                }
                if (value instanceof ContextEntity) {
                    value = ((ContextEntity)value).getContextMap();
                }
                if (value instanceof Model && JPA.em().contains(value)) {
                    value = Resource.toMapCompact(value);
                }
                if (value instanceof Collection) {
                    value = Collections2.transform((Collection)((Collection)value), item -> {
                        if (item instanceof ContextEntity) {
                            return ((ContextEntity)((Object)item)).getContextMap();
                        }
                        return item instanceof Model && JPA.em().contains(item) ? Resource.toMapCompact(item) : item;
                    });
                }
                context.put(ctx.getName(), value);
                if (handler.getContext() == null || !ctx.getName().startsWith("_")) continue;
                handler.getContext().put(ctx.getName(), value);
            }
        }
        if (!context.containsKey("_id") && handler.getContext() != null && handler.getContext().containsKey("id")) {
            context.put("_id", handler.evaluate("#{id}"));
        }
        if (this.params != null) {
            for (Param param : this.params) {
                value = param.value;
                if ("false".equals(value)) {
                    value = false;
                }
                if ("true".equals(value)) {
                    value = true;
                }
                viewParams.put(param.name, value);
            }
        }
        if ((domain = this.getDomain()) != null && (domain.contains("$") || domain.startsWith("#{") && domain.endsWith("}"))) {
            domain = handler.evaluate(ActionView.toExpression(domain, true)).toString();
        }
        if ((title = this.getLocalizedTitle()) != null && (title.contains("$") || title.startsWith("#{") && title.endsWith("}"))) {
            title = handler.evaluate(ActionView.toExpression(title, true)).toString();
        }
        result.put("actionId", this.getActionId());
        result.put("title", title);
        result.put("icon", this.getIcon());
        result.put("model", this.getModel());
        result.put("viewType", viewType);
        result.put("views", items);
        result.put("domain", domain);
        result.put("context", context);
        result.put("params", viewParams);
        return result;
    }

    @Override
    protected Object wrapper(Object value) {
        return ImmutableMap.of((Object)"view", (Object)value);
    }

    public static ActionViewBuilder define(String title) {
        return new ActionViewBuilder(title);
    }

    public static final class ActionViewBuilder {
        private ActionView view = new ActionView();
        private Map<String, Object> context = Maps.newHashMap();

        private ActionViewBuilder(String title) {
            this.view.title = title;
            this.view.views = Lists.newArrayList();
            this.view.params = Lists.newArrayList();
            this.view.contexts = Lists.newArrayList();
        }

        public ActionViewBuilder name(String name) {
            this.view.setName(name);
            return this;
        }

        public ActionViewBuilder model(String model) {
            this.view.setModel(model);
            return this;
        }

        public ActionViewBuilder icon(String icon) {
            this.view.icon = icon;
            return this;
        }

        public ActionViewBuilder add(String type) {
            return this.add(type, null);
        }

        public ActionViewBuilder add(String type, String name) {
            View item = new View();
            item.setType(type);
            item.setName(name);
            this.view.views.add(item);
            return this;
        }

        public ActionViewBuilder domain(String domain) {
            this.view.domain = domain;
            return this;
        }

        public ActionViewBuilder context(String key, Object value) {
            this.context.put(key, value);
            if (value instanceof String) {
                Context context = new Context();
                context.setName(key);
                context.setExpression((String)value);
                this.view.contexts.add(context);
            }
            return this;
        }

        public ActionViewBuilder param(String key, String value) {
            Param item = new Param();
            item.name = key;
            item.value = value;
            this.view.params.add(item);
            return this;
        }

        public ActionView get() {
            return this.view;
        }

        public Map<String, Object> map() {
            HashMap result = Maps.newHashMap();
            HashMap params = Maps.newHashMap();
            ArrayList items = Lists.newArrayList();
            String type = null;
            for (View v : this.view.views) {
                if (type == null) {
                    type = v.type;
                }
                HashMap item = Maps.newHashMap();
                item.put("type", v.getType());
                item.put("name", v.getName());
                items.add(item);
            }
            if (type == null) {
                type = "grid";
                items.add(ImmutableMap.of((Object)"type", (Object)"grid"));
                items.add(ImmutableMap.of((Object)"type", (Object)"form"));
            }
            for (Param param : this.view.params) {
                Object value = param.value;
                if ("false".equals(value)) {
                    value = false;
                }
                if ("true".equals(value)) {
                    value = true;
                }
                params.put(param.name, value);
            }
            result.put("title", this.view.title);
            result.put("icon", this.view.icon);
            result.put("model", this.view.getModel());
            result.put("viewType", type);
            result.put("views", items);
            result.put("domain", this.view.domain);
            result.put("context", this.context);
            result.put("params", params);
            return result;
        }
    }

    @XmlType
    public static class Param {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    @XmlType
    public static class Context
    extends ActionRecord.RecordField {
    }

    @XmlType
    public static class View
    extends Action.Element {
        @XmlAttribute
        private String type;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

