/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.actions;

import com.axelor.meta.ActionHandler;
import com.axelor.meta.MetaStore;
import com.axelor.meta.schema.actions.Action;
import com.axelor.text.GroovyTemplates;
import com.axelor.text.StringTemplates;
import com.axelor.text.Templates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import groovy.util.slurpersupport.GPathResult;
import groovy.xml.XmlUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import wslite.soap.SOAPClient;
import wslite.soap.SOAPResponse;

@XmlType
public class ActionWS
extends Action {
    private static final int DEFAULT_READ_TIMEOUT = 300;
    private static final int DEFAULT_CONNECT_TIMEOUT = 60;
    @XmlAttribute
    private String service;
    @XmlAttribute(name="connect-timeout")
    private Integer connectTimeout;
    @XmlAttribute(name="read-timeout")
    private Integer readTimeout;
    @XmlElement(name="action")
    private List<WSAction> methods;

    public String getService() {
        return this.service;
    }

    public Integer getConnectTimeout() {
        if (this.connectTimeout == null) {
            return 60;
        }
        return this.connectTimeout;
    }

    public Integer getReadTimeout() {
        if (this.readTimeout == null) {
            return 300;
        }
        return this.readTimeout;
    }

    public List<WSAction> getMethods() {
        return this.methods;
    }

    private ActionWS getRef() {
        if (this.service == null || !this.service.startsWith("ref:")) {
            return null;
        }
        String refName = this.service.replaceFirst("^ref:", "");
        Action ref = MetaStore.getAction(refName);
        if (ref == null || !(ref instanceof ActionWS)) {
            throw new IllegalArgumentException("No such web service: " + refName);
        }
        if (((ActionWS)ref).getService().startsWith("ref:")) {
            throw new IllegalArgumentException("Invalid web service: " + refName);
        }
        return (ActionWS)ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object send(String location, WSAction act, String template, ActionHandler handler) throws IOException, FileNotFoundException, ClassNotFoundException {
        File templateFile = new File(template);
        if (!templateFile.isFile()) {
            throw new IllegalArgumentException("No such template: " + template);
        }
        Templates engine = new StringTemplates('$', '$');
        if ("groovy".equals(act.engine)) {
            engine = new GroovyTemplates();
        }
        String payload = null;
        try (FileReader reader = new FileReader(templateFile);){
            payload = handler.template(engine, reader);
        }
        HashMap params = Maps.newHashMap();
        params.put("connectTimeout", this.getConnectTimeout() * 1000);
        params.put("readTimeout", this.getReadTimeout() * 1000);
        SOAPClient client = new SOAPClient(location);
        SOAPResponse response = client.send((Map)params, payload);
        GPathResult gpath = ((GPathResult)response.getBody()).children();
        String ns = gpath.lookupNamespace("");
        if (ns != null) {
            gpath.declareNamespace((Map)ImmutableMap.of((Object)":", (Object)ns));
        }
        return XmlUtil.serialize((GPathResult)gpath);
    }

    private String getService(ActionWS ref, ActionHandler handler) {
        String url = ref == null ? this.service : ref.getService();
        Object service = handler.evaluate(url);
        if (service == null) {
            this.log.error("No such service: " + url);
            return null;
        }
        return service.toString();
    }

    @Override
    public Object evaluate(ActionHandler handler) {
        ActionWS ref = this.getRef();
        String url = this.getService(ref, handler);
        if (Strings.isNullOrEmpty((String)url)) {
            return null;
        }
        if (ref != null) {
            ref.evaluate(handler);
        }
        ArrayList result = Lists.newArrayList();
        this.log.info("action-ws (name): " + this.getName());
        for (WSAction act : this.methods) {
            Object template = handler.evaluate(act.template);
            if (template == null) {
                this.log.error("No such template: " + template);
                continue;
            }
            this.log.info("action-ws (method, template): " + act.getName() + ", " + template.toString());
            try {
                Object res = this.send(url, act, template.toString(), handler);
                result.add(res);
            }
            catch (Exception e) {
                this.log.error("error: " + e);
            }
        }
        return result;
    }

    @XmlType
    public static class WSAction
    extends Action.Element {
        @XmlAttribute
        private String template;
        @XmlAttribute
        private String engine;

        public String getTemplate() {
            return this.template;
        }

        public String getEngine() {
            return this.engine;
        }
    }
}

