/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.views;

import com.axelor.db.mapper.Mapper;
import com.axelor.meta.schema.views.Break;
import com.axelor.meta.schema.views.Button;
import com.axelor.meta.schema.views.Dashlet;
import com.axelor.meta.schema.views.Field;
import com.axelor.meta.schema.views.Group;
import com.axelor.meta.schema.views.Help;
import com.axelor.meta.schema.views.Label;
import com.axelor.meta.schema.views.Notebook;
import com.axelor.meta.schema.views.Page;
import com.axelor.meta.schema.views.Portlet;
import com.axelor.meta.schema.views.Separator;
import com.axelor.meta.schema.views.Spacer;
import com.axelor.meta.schema.views.Static;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;

@XmlType
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=Field.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Field.class), @JsonSubTypes.Type(value=Button.class), @JsonSubTypes.Type(value=Break.class), @JsonSubTypes.Type(value=Spacer.class), @JsonSubTypes.Type(value=Separator.class), @JsonSubTypes.Type(value=Label.class), @JsonSubTypes.Type(value=Static.class), @JsonSubTypes.Type(value=Help.class), @JsonSubTypes.Type(value=Group.class), @JsonSubTypes.Type(value=Notebook.class), @JsonSubTypes.Type(value=Page.class), @JsonSubTypes.Type(value=Portlet.class), @JsonSubTypes.Type(value=Dashlet.class)})
public abstract class AbstractWidget {
    @JsonIgnore
    @XmlAttribute(name="if")
    private String conditionToCheck;
    @JsonIgnore
    @XmlAttribute(name="if-module")
    private String moduleToCheck;
    @JsonIgnore
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes;
    @XmlTransient
    @JsonIgnore
    private String model;

    public String getConditionToCheck() {
        return this.conditionToCheck;
    }

    public void setConditionToCheck(String conditionToCheck) {
        this.conditionToCheck = conditionToCheck;
    }

    public String getModuleToCheck() {
        return this.moduleToCheck;
    }

    public void setModuleToCheck(String moduleToCheck) {
        this.moduleToCheck = moduleToCheck;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public void setOtherAttributes(Map<QName, String> otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    @XmlTransient
    public Map<String, Object> getWidgetAttrs() {
        if (this.otherAttributes == null || this.otherAttributes.isEmpty()) {
            return null;
        }
        HashMap attrs = Maps.newHashMap();
        for (QName qn : this.otherAttributes.keySet()) {
            String name = qn.getLocalPart();
            String value = this.otherAttributes.get(qn);
            if (!name.startsWith("x-") && !name.startsWith("data-")) continue;
            name = name.replaceFirst("^(x|data)-", "");
            name = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, name);
            attrs.put(name, value);
        }
        if (attrs.containsKey("target") && !attrs.containsKey("targetName")) {
            try {
                Class<?> target = Class.forName(attrs.get("target").toString());
                String targetName = Mapper.of(target).getNameField().getName();
                attrs.put("targetName", targetName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attrs;
    }

    @XmlTransient
    public void setWidgetAttrs(Map<String, Object> attrs) {
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }
}

