/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.views;

import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.meta.MetaStore;
import com.axelor.meta.schema.views.CardsView;
import com.axelor.meta.schema.views.Selection;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlType
@JsonTypeName(value="kanban")
public class KanbanView
extends CardsView {
    @XmlAttribute
    private String columnBy;
    @XmlAttribute
    private String sequenceBy;
    @XmlAttribute
    private Boolean draggable = Boolean.TRUE;
    @XmlAttribute
    private String onNew;
    @XmlAttribute
    private String onMove;
    @XmlAttribute
    private Integer limit;
    @JsonIgnore
    @XmlAttribute(name="x-limit-columns")
    private Integer limitColumns;

    public String getColumnBy() {
        return this.columnBy;
    }

    public void setColumnBy(String columnBy) {
        this.columnBy = columnBy;
    }

    public String getSequenceBy() {
        return this.sequenceBy;
    }

    public void setSequenceBy(String sequenceBy) {
        this.sequenceBy = sequenceBy;
    }

    public Boolean getDraggable() {
        return this.draggable;
    }

    public void setDraggable(Boolean draggable) {
        this.draggable = draggable;
    }

    public String getOnNew() {
        return this.onNew;
    }

    public void setOnNew(String onNew) {
        this.onNew = onNew;
    }

    public String getOnMove() {
        return this.onMove;
    }

    public void setOnMove(String onMove) {
        this.onMove = onMove;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    private Class<?> getModelClass() {
        try {
            return Class.forName(this.getModel());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Invalid Kanban view", e);
        }
    }

    @XmlTransient
    @JsonProperty
    public List<Selection.Option> getColumns() {
        Mapper mapper = Mapper.of(this.getModelClass());
        Property columnField = mapper.getProperty(this.columnBy);
        if (columnField == null) {
            throw new RuntimeException("Null field found: " + this.columnBy);
        }
        if (columnField.isEnum()) {
            return MetaStore.getSelectionList(columnField.getEnumType());
        }
        if (StringUtils.notBlank((CharSequence)columnField.getSelection())) {
            return MetaStore.getSelectionList(columnField.getSelection());
        }
        if (columnField.isReference()) {
            Class<Model> targetClass = columnField.getTarget().asSubclass(Model.class);
            Mapper targetMapper = Mapper.of(targetClass);
            int limit = this.limitColumns == null ? 12 : this.limitColumns;
            String orderBy = targetMapper.getProperty("sequence") == null ? null : "sequence";
            return MetaStore.getSelectionList(targetClass, orderBy, limit);
        }
        throw new RuntimeException("Invalid columnBy: " + this.columnBy);
    }
}

