/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.schema.views;

import com.axelor.common.StringUtils;
import com.axelor.meta.MetaStore;
import com.axelor.meta.schema.views.AbstractPanel;
import com.axelor.meta.schema.views.AbstractWidget;
import com.axelor.meta.schema.views.Button;
import com.axelor.meta.schema.views.Field;
import com.axelor.meta.schema.views.Label;
import com.axelor.meta.schema.views.Panel;
import com.axelor.meta.schema.views.PanelField;
import com.axelor.meta.schema.views.SimpleWidget;
import com.axelor.meta.schema.views.Spacer;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlType
@JsonTypeName(value="editor")
public class PanelEditor
extends AbstractPanel {
    transient PanelField forField;
    transient List<Object> targetFields;
    @XmlAttribute
    private String layout;
    @XmlAttribute(name="x-viewer")
    private Boolean viewer;
    @XmlAttribute(name="x-show-on-new")
    private Boolean showOnNew;
    @XmlAttribute
    private String onNew;
    @XmlElements(value={@XmlElement(name="field", type=PanelField.class), @XmlElement(name="button", type=Button.class), @XmlElement(name="spacer", type=Spacer.class), @XmlElement(name="label", type=Label.class), @XmlElement(name="panel", type=Panel.class)})
    private List<AbstractWidget> items;

    public String getLayout() {
        return this.layout;
    }

    public Boolean getViewer() {
        return this.viewer;
    }

    public Boolean getShowOnNew() {
        return this.showOnNew;
    }

    public String getOnNew() {
        return this.onNew;
    }

    public List<AbstractWidget> getItems() {
        this.getTargetFields();
        return this.process(this.items);
    }

    public void setItems(List<AbstractWidget> items) {
        this.items = items;
    }

    private Set<String> findFields(AbstractWidget widget) {
        HashSet<String> all;
        block6: {
            block5: {
                String depends;
                all = new HashSet<String>();
                if (widget instanceof SimpleWidget && StringUtils.notBlank((CharSequence)(depends = ((SimpleWidget)widget).getDepends()))) {
                    Collections.addAll(all, depends.trim().split("\\s*,\\s*"));
                }
                if (widget instanceof Field) {
                    all.add(((Field)widget).getName());
                    String relatedAttr = ((Field)widget).getRelated();
                    if (StringUtils.notBlank((CharSequence)relatedAttr)) {
                        all.add(relatedAttr);
                    }
                    return all;
                }
                if (!(widget instanceof PanelEditor)) break block5;
                for (AbstractWidget item : ((PanelEditor)widget).getItems()) {
                    all.addAll(this.findFields(item));
                }
                break block6;
            }
            if (!(widget instanceof Panel)) break block6;
            for (AbstractWidget item : ((Panel)widget).getItems()) {
                all.addAll(this.findFields(item));
            }
        }
        return all;
    }

    @JsonGetter(value="fields")
    public List<Object> getTargetFields() {
        Class<?> target;
        if (this.targetFields != null || this.items == null || this.forField == null || this.forField.getTarget() == null) {
            return this.targetFields;
        }
        this.targetFields = new ArrayList<Object>();
        try {
            target = Class.forName(this.forField.getTarget());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Map<String, Object> fields = MetaStore.findFields(target, this.findFields(this));
        this.targetFields.addAll((Collection)fields.get("fields"));
        return this.targetFields;
    }
}

