/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.service;

import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.db.annotations.Widget;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.google.inject.persist.Transactional;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Formula;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaModelService {
    private static Logger log = LoggerFactory.getLogger(MetaModelService.class);
    @Inject
    private MetaModelRepository models;
    @Inject
    private MetaFieldRepository fields;

    @Transactional
    public void process() {
        for (Class<?> klass : JPA.models()) {
            this.process(klass);
        }
    }

    @Transactional
    public void process(Class<?> klass) {
        if (Modifier.isAbstract(klass.getModifiers())) {
            return;
        }
        MetaModel entity = this.models.all().filter("self.fullName = ?1", klass.getName()).count() == 0L ? this.createEntity(klass) : this.updateEntity(klass);
        this.models.save(entity);
    }

    private MetaModel createEntity(Class<?> klass) {
        log.trace("Create entities : {}", (Object)klass.getName());
        MetaModel metaModel = new MetaModel();
        metaModel.setName(klass.getSimpleName());
        metaModel.setFullName(klass.getName());
        metaModel.setPackageName(klass.getPackage().getName());
        if (klass.getAnnotation(Table.class) != null) {
            metaModel.setTableName(klass.getAnnotation(Table.class).name());
        }
        metaModel.setMetaFields(new ArrayList<MetaField>());
        metaModel.getMetaFields().addAll(this.createFields(metaModel, klass));
        return metaModel;
    }

    private MetaModel updateEntity(Class<?> klass) {
        MetaModel metaModel = MetaModelService.getMetaModel(klass);
        Mapper mapper = Mapper.of(klass);
        for (Property property : mapper.getProperties()) {
            if (this.fields.all().filter("self.metaModel = ?1 AND self.name = ?2", metaModel, property.getName()).count() != 0L) continue;
            metaModel.getMetaFields().add(this.createField(metaModel, this.getField(klass, property.getName()), property));
        }
        return metaModel;
    }

    private MetaField createField(MetaModel metaModel, Field field, Property property) {
        MetaField metaField = null;
        if (!(field.isSynthetic() || field.isAnnotationPresent(Formula.class) || Modifier.isTransient(field.getModifiers()))) {
            log.trace("Create field : {}", (Object)field.getName());
            metaField = new MetaField();
            metaField.setMetaModel(metaModel);
            metaField.setName(field.getName());
            metaField.setTypeName(field.getType().getSimpleName());
            metaField.setJson(property.isJson());
            if (field.getType().getPackage() != null) {
                metaField.setPackageName(field.getType().getPackage().getName());
            }
            if (field.getType().isEnum()) {
                metaField.setTypeName(field.getType().getSimpleName());
            }
            if (field.isAnnotationPresent(Widget.class)) {
                metaField.setLabel(field.getAnnotation(Widget.class).title());
                metaField.setDescription(field.getAnnotation(Widget.class).help());
            }
            if (field.isAnnotationPresent(ManyToOne.class)) {
                metaField.setRelationship(ManyToOne.class.getSimpleName());
            }
            if (field.isAnnotationPresent(ManyToMany.class)) {
                metaField.setRelationship(ManyToMany.class.getSimpleName());
                metaField.setMappedBy(field.getAnnotation(ManyToMany.class).mappedBy());
                metaField.setTypeName(this.getGenericClassName(field));
                metaField.setPackageName(this.getGenericPackageName(field));
            }
            if (field.isAnnotationPresent(OneToMany.class)) {
                metaField.setRelationship(OneToMany.class.getSimpleName());
                metaField.setMappedBy(field.getAnnotation(OneToMany.class).mappedBy());
                metaField.setTypeName(this.getGenericClassName(field));
                metaField.setPackageName(this.getGenericPackageName(field));
            }
            if (field.isAnnotationPresent(OneToOne.class)) {
                metaField.setRelationship(OneToOne.class.getSimpleName());
                metaField.setMappedBy(field.getAnnotation(OneToOne.class).mappedBy());
            }
        }
        return metaField;
    }

    private List<MetaField> createFields(MetaModel metaModel, Class<?> klass) {
        ArrayList<MetaField> modelFields = new ArrayList<MetaField>();
        Mapper mapper = Mapper.of(klass);
        for (Property property : mapper.getProperties()) {
            MetaField metaField = this.createField(metaModel, this.getField(klass, property.getName()), property);
            if (metaField == null) continue;
            modelFields.add(metaField);
        }
        return modelFields;
    }

    private String getGenericCanonicalName(Field field) {
        Type type = field.getGenericType();
        String typeName = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            for (Type t : pt.getActualTypeArguments()) {
                typeName = t.toString();
            }
        }
        return typeName;
    }

    private String getGenericClassName(Field field) {
        String typeName = this.getGenericCanonicalName(field);
        if (typeName != null) {
            typeName = typeName.replace("class ", "");
            String[] splitName = typeName.split("\\.");
            typeName = splitName[splitName.length - 1];
        }
        return typeName;
    }

    private String getGenericPackageName(Field field) {
        String typeName = this.getGenericCanonicalName(field);
        if (typeName != null) {
            typeName = typeName.replace("class ", "");
            String[] splitName = typeName.split("\\.");
            typeName = typeName.replace("." + splitName[splitName.length - 1], "");
        }
        return typeName;
    }

    private Field getField(Class<?> klass, String name) {
        try {
            return klass.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            return this.getField(klass.getSuperclass(), name);
        }
    }

    public static MetaModel getMetaModel(Class<?> klass) {
        return Query.of(MetaModel.class).filter("self.fullName = ?1", klass.getName()).fetchOne();
    }
}

