/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.service;

import com.axelor.app.internal.AppFilter;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.User;
import com.axelor.common.ObjectUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.JpaSecurity;
import com.axelor.db.Model;
import com.axelor.db.QueryBinder;
import com.axelor.db.mapper.Mapper;
import com.axelor.inject.Beans;
import com.axelor.meta.ActionExecutor;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaActionMenu;
import com.axelor.meta.db.MetaAttachment;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaMenu;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.MetaViewCustom;
import com.axelor.meta.db.repo.MetaFileRepository;
import com.axelor.meta.db.repo.MetaHelpRepository;
import com.axelor.meta.db.repo.MetaViewCustomRepository;
import com.axelor.meta.db.repo.MetaViewRepository;
import com.axelor.meta.loader.ModuleManager;
import com.axelor.meta.loader.XMLViews;
import com.axelor.meta.schema.actions.Action;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.meta.schema.views.ChartView;
import com.axelor.meta.schema.views.CustomView;
import com.axelor.meta.schema.views.DataSet;
import com.axelor.meta.schema.views.MenuItem;
import com.axelor.meta.schema.views.Search;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Request;
import com.axelor.rpc.Response;
import com.axelor.rpc.filter.Filter;
import com.axelor.rpc.filter.JPQLFilter;
import com.axelor.script.CompositeScriptHelper;
import com.axelor.script.ScriptBindings;
import com.axelor.script.ScriptHelper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaService {
    private static final Logger LOG = LoggerFactory.getLogger(MetaService.class);
    @Inject
    private MetaViewRepository views;
    @Inject
    private MetaViewCustomRepository customViews;
    @Inject
    private MetaFileRepository files;
    @Inject
    private MetaFiles metaFiles;
    @Inject
    private ActionExecutor actionExecutor;

    private boolean canShow(MenuItem item, Map<String, MenuItem> map, Set<String> visited, ScriptHelper helper) {
        if (visited == null) {
            visited = new HashSet<String>();
        }
        if (visited.contains(item.getName())) {
            LOG.warn("Recursion detected at menu: " + item.getName());
            return false;
        }
        visited.add(item.getName());
        if (item.getHidden() == Boolean.TRUE || !this.test(item, helper)) {
            return false;
        }
        if (item.getParent() == null) {
            return true;
        }
        MenuItem parent = map.get(item.getParent());
        if (parent == null) {
            return false;
        }
        return this.canShow(parent, map, visited, helper);
    }

    private boolean test(MenuItem item, ScriptHelper helper) {
        String module = item.getModuleToCheck();
        String condition = item.getConditionToCheck();
        if (!StringUtils.isBlank((CharSequence)module) && !ModuleManager.isInstalled(module)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)condition)) {
            return true;
        }
        return helper.test(condition);
    }

    private List<MenuItem> filter(Collection<MenuItem> items) {
        LinkedHashMap<String, MenuItem> map = new LinkedHashMap<String, MenuItem>();
        HashSet<String> visited = new HashSet<String>();
        ArrayList<MenuItem> all = new ArrayList<MenuItem>();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        CompositeScriptHelper scriptHelper = new CompositeScriptHelper(new ScriptBindings(vars));
        for (MenuItem item : items) {
            String name = item.getName();
            if (visited.contains(name)) continue;
            visited.add(name);
            if (item.getHidden() == Boolean.TRUE) continue;
            map.put(name, item);
        }
        for (String name : map.keySet()) {
            MenuItem item = (MenuItem)map.get(name);
            if (!this.canShow(item, map, null, scriptHelper)) continue;
            all.add(item);
        }
        Collections.sort(all, new Comparator<MenuItem>(){

            @Override
            public int compare(MenuItem a, MenuItem b) {
                Integer n = a.getOrder();
                Integer m = b.getOrder();
                if (n == null) {
                    n = 0;
                }
                if (m == null) {
                    m = 0;
                }
                return Integer.compare(n, m);
            }
        });
        return all;
    }

    private String getTag(MetaMenu item) {
        String tag = item.getTag();
        String call = item.getTagGet();
        MetaAction action = item.getAction();
        if (tag != null) {
            return tag;
        }
        if (call != null) {
            ActionRequest request = new ActionRequest();
            request.setAction(call);
            try {
                return (String)this.actionExecutor.execute(request).getItem(0);
            }
            catch (Exception e) {
                LOG.error("Unable to read tag for menu: {}", (Object)item.getName());
                LOG.trace("Error", (Throwable)e);
                return null;
            }
        }
        if (item.getTagCount() == Boolean.TRUE && action != null) {
            ActionView act;
            try {
                act = (ActionView)MetaStore.getAction(action.getName());
            }
            catch (Exception e) {
                return null;
            }
            if (act == null) {
                return null;
            }
            ActionRequest request = new ActionRequest();
            request.setAction(action.getName());
            request.setModel(action.getModel());
            request.setData(new HashMap<String, Object>());
            try {
                String domain;
                JpaSecurity security = Beans.get(JpaSecurity.class);
                ArrayList<Filter> filters = new ArrayList<Filter>();
                Class<?> modelClass = request.getBeanClass();
                Filter securityFilter = security.getFilter(JpaSecurity.CAN_READ, modelClass, new Long[0]);
                if (securityFilter != null) {
                    filters.add(securityFilter);
                } else if (!security.isPermitted(JpaSecurity.CAN_READ, modelClass, new Long[0])) {
                    return null;
                }
                Map data = (Map)((Map)this.actionExecutor.execute(request).getItem(0)).get("view");
                Map params = (Map)data.get("params");
                if (params == null || !Boolean.TRUE.equals(params.get("showArchived"))) {
                    filters.add(new JPQLFilter("self.archived IS NULL OR self.archived = FALSE", new Object[0]));
                }
                if (StringUtils.notBlank((CharSequence)(domain = (String)data.get("domain")))) {
                    filters.add(JPQLFilter.forDomain(domain, new Object[0]));
                }
                Filter filter = Filter.and(filters);
                Map context = (Map)data.get("context");
                return String.valueOf(filter.build(modelClass).bind(context).count());
            }
            catch (Exception e) {
                LOG.error("Unable to read tag for menu: {}", (Object)item.getName());
                LOG.trace("Error", (Throwable)e);
            }
        }
        return null;
    }

    public List<MenuItem> getMenus(boolean withTagsOnly) {
        return this.getMenus(withTagsOnly, false, Collections.emptyList());
    }

    public List<MenuItem> getMenus(boolean withTagsOnly, boolean inNamesOnly, List<String> names) {
        List queryResults;
        User user;
        if (!withTagsOnly) {
            XMLViews.applyHotUpdates();
        }
        if ((user = AuthUtils.getUser()) == null) {
            return Collections.emptyList();
        }
        HashMap<Object, HashSet<String>> menuGroups = new HashMap<Object, HashSet<String>>();
        HashMap<Object, HashSet<String>> menuRoles = new HashMap<Object, HashSet<String>>();
        Query permsQuery = JPA.em().createQuery("SELECT new List(m.id, g.code, r.name) FROM MetaMenu m LEFT JOIN m.groups g LEFT JOIN m.roles r");
        QueryBinder.of(permsQuery).setCacheable();
        for (Object item2 : permsQuery.getResultList()) {
            List vals = (List)item2;
            Long id = (Long)vals.get(0);
            if (vals.get(1) != null) {
                HashSet<String> groups = (HashSet<String>)menuGroups.get(id);
                if (groups == null) {
                    groups = new HashSet<String>();
                    menuGroups.put(id, groups);
                }
                groups.add(vals.get(1).toString());
            }
            if (vals.get(2) == null) continue;
            HashSet<String> roles = (HashSet<String>)menuRoles.get(id);
            if (roles == null) {
                roles = new HashSet<String>();
                menuRoles.put(id, roles);
            }
            roles.add(vals.get(2).toString());
        }
        if (inNamesOnly && ObjectUtils.isEmpty(names)) {
            queryResults = Collections.emptyList();
        } else {
            StringBuilder queryString = new StringBuilder().append("SELECT self FROM MetaMenu self ").append("LEFT JOIN FETCH self.action ").append("LEFT JOIN FETCH self.parent");
            if (withTagsOnly) {
                queryString.append(" WHERE (self.tag IS NOT NULL OR self.tagGet IS NOT NULL OR self.tagCount IS NOT NULL)");
            }
            if (inNamesOnly) {
                queryString.append(withTagsOnly ? " AND" : " WHERE");
                queryString.append(" self.name IN :names");
            }
            queryString.append(" ORDER BY COALESCE(self.priority, 0) DESC, self.id");
            TypedQuery query = JPA.em().createQuery(queryString.toString(), MetaMenu.class);
            QueryBinder.of((Query)query).setCacheable().bind("names", names);
            queryResults = query.getResultList();
        }
        LinkedHashMap<MenuItem, MetaMenu> menus = new LinkedHashMap<MenuItem, MetaMenu>();
        ArrayList<MetaMenu> records = new ArrayList<MetaMenu>();
        for (MetaMenu menu : queryResults) {
            records.add(menu);
            while (withTagsOnly && menu.getParent() != null) {
                menu = menu.getParent();
                records.add(menu);
            }
        }
        String userGroup = user.getGroup() == null ? null : user.getGroup().getCode();
        ArrayList<String> userRoles = new ArrayList<String>();
        if (user.getRoles() != null) {
            for (Role role : user.getRoles()) {
                userRoles.add(role.getName());
            }
        }
        if (user.getGroup() != null && user.getGroup().getRoles() != null) {
            for (Role role : user.getGroup().getRoles()) {
                userRoles.add(role.getName());
            }
        }
        HashMap help = new HashMap();
        if (!withTagsOnly && user.getNoHelp() != Boolean.TRUE) {
            MetaHelpRepository helpRepo = Beans.get(MetaHelpRepository.class);
            String lang = AppFilter.getLocale() == null ? "en" : AppFilter.getLocale().getLanguage();
            helpRepo.all().filter("self.menu is not null and self.language = :lang").bind("lang", lang).cacheable().select("menu", "help").fetch(-1, 0).forEach(item -> help.put((String)item.get("menu"), (String)item.get("help")));
        }
        HashSet<String> denied = new HashSet<String>();
        for (MetaMenu menu : records) {
            boolean allowed;
            if (menu.getUser() != null && menu.getUser() != user) continue;
            Set myGroups = (Set)menuGroups.get(menu.getId());
            Set myRoles = (Set)menuRoles.get(menu.getId());
            boolean bl = allowed = AuthUtils.isAdmin(user) || myGroups != null && myGroups.contains(userGroup) || myRoles != null && !Collections.disjoint(userRoles, myRoles) || myRoles == null && myGroups == null && menu.getParent() != null;
            if (!allowed || denied.contains(menu.getName())) {
                denied.add(menu.getName());
                continue;
            }
            MenuItem item3 = new MenuItem();
            item3.setName(menu.getName());
            item3.setOrder(menu.getOrder());
            item3.setTitle(menu.getTitle());
            item3.setIcon(menu.getIcon());
            item3.setIconBackground(menu.getIconBackground());
            item3.setHasTag(menu.getTagCount() != false || StringUtils.notEmpty((CharSequence)menu.getTagGet()));
            item3.setTagStyle(menu.getTagStyle());
            item3.setTop(menu.getTop());
            item3.setLeft(menu.getLeft());
            item3.setMobile(menu.getMobile());
            item3.setHidden(menu.getHidden());
            item3.setModuleToCheck(menu.getModuleToCheck());
            item3.setConditionToCheck(menu.getConditionToCheck());
            if (help.containsKey(menu.getName())) {
                item3.setHelp((String)help.get(menu.getName()));
            }
            if (menu.getParent() != null) {
                item3.setParent(menu.getParent().getName());
            }
            if (menu.getAction() != null) {
                item3.setAction(menu.getAction().getName());
            }
            menus.put(item3, menu);
        }
        List<MenuItem> items = this.filter(menus.keySet());
        items.forEach(item -> item.setTag(this.getTag((MetaMenu)menus.get(item))));
        return items;
    }

    public List<MenuItem> getActionMenus(String parent, String category) {
        if ("null".equals(parent)) {
            parent = null;
        }
        if ("null".equals(category)) {
            category = null;
        }
        String str = "SELECT self, COALESCE(self.priority, 0) AS priority FROM MetaActionMenu self WHERE self.parent.name = ?1";
        if (Strings.isNullOrEmpty((String)parent)) {
            str = "SELECT self, COALESCE(self.priority, 0) AS priority FROM MetaActionMenu self WHERE self.parent IS NULL";
        }
        if (!Strings.isNullOrEmpty((String)category)) {
            str = str + " AND self.category = ?2";
        }
        str = str + " ORDER BY self.name, priority DESC";
        Query query = JPA.em().createQuery(str);
        if (!Strings.isNullOrEmpty((String)parent)) {
            query.setParameter(1, (Object)parent);
        }
        if (!Strings.isNullOrEmpty((String)category)) {
            query.setParameter(2, (Object)category);
        }
        QueryBinder.of(query).setCacheable();
        ArrayList<MenuItem> menus = new ArrayList<MenuItem>();
        List all = query.getResultList();
        for (Object[] items : all) {
            MetaActionMenu menu = (MetaActionMenu)items[0];
            MenuItem item = new MenuItem();
            item.setName(menu.getName());
            item.setTitle(menu.getTitle());
            item.setOrder(menu.getOrder());
            item.setHidden(menu.getHidden());
            if (menu.getParent() != null) {
                item.setParent(menu.getParent().getName());
            }
            if (menu.getAction() != null) {
                item.setAction(menu.getAction().getName());
            }
            if (menu.getCategory() != null) {
                item.setCategory(menu.getCategory());
            }
            menus.add(item);
        }
        return this.filter(menus);
    }

    public Action getAction(String name) {
        return XMLViews.findAction(name);
    }

    public Response findViews(Class<?> model, Map<String, String> views) {
        Response response = new Response();
        Map<String, Object> data = XMLViews.findViews(model.getName(), views);
        response.setData(data);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    public Response findView(String model, String name, String type) {
        Response response = new Response();
        AbstractView data = XMLViews.findView(name, type, model);
        response.setData(data);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    @Transactional
    public Response saveView(AbstractView view, User user) {
        Response response = new Response();
        String xml = XMLViews.toXml(view, true);
        MetaViewCustom entity = this.customViews.findByUser(view.getName(), user);
        if (entity == null) {
            entity = new MetaViewCustom();
            entity.setName(view.getName());
            entity.setType(view.getType());
            entity.setModel(view.getModel());
            entity.setUser(user);
        }
        entity.setTitle(view.getTitle());
        entity.setXml(xml);
        this.customViews.save(entity);
        response.setData(view);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    @Transactional
    public int removeCustomViews(MetaView view) {
        if (view == null || StringUtils.isBlank((CharSequence)view.getName())) {
            return 0;
        }
        Query deleteQuery = JPA.em().createQuery("DELETE FROM MetaViewCustom self WHERE self.name = :name");
        deleteQuery.setParameter("name", (Object)view.getName());
        return deleteQuery.executeUpdate();
    }

    public Response runSearch(Request request) {
        Response response = new Response();
        Map<String, Object> context = request.getData();
        String name = (String)context.get("__name");
        List selected = (List)context.get("__selected");
        LOG.debug("Search : {}", (Object)name);
        Search search = (Search)XMLViews.findView(name, "search");
        ScriptHelper helper = search.scriptHandler(context);
        ArrayList data = Lists.newArrayList();
        for (Search.SearchSelect select : search.getSelects()) {
            Query query;
            if (selected != null && !selected.contains(select.getModel())) continue;
            LOG.debug("Model : {}", (Object)select.getModel());
            LOG.debug("Param : {}", context);
            try {
                query = select.toQuery(search, helper);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            List items = Lists.newArrayList();
            LOG.debug("Query : {}", (Object)select.getQueryString());
            if (query != null) {
                query.setFirstResult(request.getOffset());
                query.setMaxResults(search.getLimit().intValue());
                items = query.getResultList();
            }
            LOG.debug("Found : {}", (Object)items.size());
            for (Object item : items) {
                if (!(item instanceof Map)) continue;
                ((Map)item).put("_model", select.getModel());
                ((Map)item).put("_modelTitle", select.getLocalizedTitle());
                ((Map)item).put("_form", select.getFormView());
                ((Map)item).put("_grid", select.getGridView());
            }
            data.addAll(items);
        }
        LOG.debug("Total : {}", (Object)data.size());
        response.setData(data);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    public Response getAttachment(long id, String model, Request request) {
        Response response = new Response();
        List<String> fields = request.getFields();
        com.axelor.db.Query<MetaFile> query = JPA.all(MetaFile.class).filter("self.id IN (SELECT a.metaFile FROM MetaAttachment a WHERE a.objectName = :model AND a.objectId = :id)");
        query.bind("model", model);
        query.bind("id", id);
        List<Map> data = query.select(fields.toArray(new String[0])).fetch(-1, -1);
        response.setData(data);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    @Transactional
    public Response removeAttachment(Request request) {
        Response response = new Response();
        ArrayList result = Lists.newArrayList();
        List<Object> records = request.getRecords();
        if (records == null || records.isEmpty()) {
            return response.fail("No records provides.");
        }
        for (Object record : records) {
            Long fileId = Long.valueOf(((Map)record).get("id").toString());
            if (fileId == null) continue;
            MetaFile obj = (MetaFile)this.files.find(fileId);
            try {
                this.metaFiles.delete(obj);
                result.add(record);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        response.setData(result);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    @Transactional
    public Response addAttachment(long id, Request request) {
        Response response = new Response();
        Map<String, Object> data = request.getData();
        HashMap map = Maps.newHashMap();
        MetaFile fileBean = JPA.find(MetaFile.class, Long.valueOf(data.get("id").toString()));
        map.put("metaFile", fileBean);
        map.put("objectId", id);
        map.put("objectName", request.getModel());
        MetaAttachment attBean = Mapper.toBean(MetaAttachment.class, map);
        JPA.manage((Model)attBean);
        response.setData(attBean);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    public Response getChart(String name, Request request) {
        boolean hasDataSet;
        Response response = new Response();
        MetaView view = this.views.findByName(name);
        if (view == null) {
            return response;
        }
        ChartView chart = (ChartView)XMLViews.findView(name, "chart");
        if (chart == null) {
            return response;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        response.setData(data);
        response.setStatus(Response.STATUS_SUCCESS);
        boolean bl = hasDataSet = request.getFields() != null && request.getFields().contains("dataset");
        if (hasDataSet) {
            String string = chart.getDataSet().getText();
            HashMap context = Maps.newHashMap();
            if (request.getData() != null) {
                context.putAll(request.getData());
            }
            if (AuthUtils.getUser() != null) {
                context.put("__user__", AuthUtils.getUser());
                context.put("__userId__", AuthUtils.getUser().getId());
                context.put("__userCode__", AuthUtils.getUser().getCode());
            }
            if ("rpc".equals(chart.getDataSet().getType())) {
                ActionRequest req = new ActionRequest();
                ActionResponse res = new ActionResponse();
                HashMap<String, Object> reqData = new HashMap<String, Object>();
                reqData.put("context", context);
                req.setModel(request.getModel());
                req.setData(reqData);
                req.setAction(string);
                if (req.getModel() == null) {
                    req.setModel(ScriptBindings.class.getName());
                }
                res = this.actionExecutor.execute(req);
                data.put("dataset", res.getData());
            } else {
                Query query = "sql".equals(chart.getDataSet().getType()) ? JPA.em().createNativeQuery(string) : JPA.em().createQuery(string);
                this.transformQueryResult(query);
                if (request.getData() != null) {
                    QueryBinder.of(query).bind(context, new Object[0]);
                }
                data.put("dataset", query.getResultList());
            }
        }
        if (hasDataSet) {
            return response;
        }
        data.put("title", chart.getLocalizedTitle());
        data.put("stacked", chart.getStacked());
        data.put("xAxis", chart.getCategory().getKey());
        data.put("xType", chart.getCategory().getType());
        data.put("xTitle", chart.getCategory().getLocalizedTitle());
        ArrayList series = Lists.newArrayList();
        HashMap config = Maps.newHashMap();
        for (ChartView.ChartSeries cs : chart.getSeries()) {
            HashMap map = Maps.newHashMap();
            map.put("key", cs.getKey());
            map.put("type", cs.getType());
            map.put("groupBy", cs.getGroupBy());
            map.put("aggregate", cs.getAggregate());
            map.put("title", cs.getLocalizedTitle());
            map.put("scale", cs.getScale());
            series.add(map);
        }
        if (chart.getConfig() != null) {
            for (ChartView.ChartConfig c : chart.getConfig()) {
                config.put(c.getName(), c.getValue());
            }
        }
        data.put("series", series);
        data.put("config", config);
        data.put("search", chart.getSearchFields());
        data.put("onInit", chart.getOnInit());
        if ("sql".equals(chart.getDataSet().getType())) {
            data.put("usingSQL", true);
        }
        return response;
    }

    public Response getDataSet(String viewName, Request request) {
        Response response = new Response();
        MetaView metaView = this.views.findByName(viewName);
        if (metaView == null) {
            return response;
        }
        CustomView report = (CustomView)XMLViews.findView(viewName, "report");
        if (report == null) {
            return response;
        }
        DataSet dataSet = report.getDataSet();
        HashMap<String, Object> data = new HashMap<String, Object>();
        response.setData(data);
        response.setStatus(Response.STATUS_SUCCESS);
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (request.getData() != null) {
            context.putAll(request.getData());
        }
        if (AuthUtils.getUser() != null) {
            context.put("__user__", AuthUtils.getUser());
            context.put("__userId__", AuthUtils.getUser().getId());
            context.put("__userCode__", AuthUtils.getSubject());
        }
        if ("rpc".equals(dataSet.getType())) {
            ActionRequest req = new ActionRequest();
            ActionResponse res = new ActionResponse();
            req.setModel(request.getModel());
            req.setData(request.getData());
            req.setAction(dataSet.getText());
            if (req.getModel() == null) {
                req.setModel(ScriptBindings.class.getName());
            }
            res = this.actionExecutor.execute(req);
            data.put("dataset", res.getData());
        } else {
            Query query;
            Query query2 = query = "sql".equals(report.getDataSet().getType()) ? JPA.em().createNativeQuery(dataSet.getText()) : JPA.em().createQuery(dataSet.getText());
            if (request.getLimit() > 0) {
                query.setMaxResults(request.getLimit());
            }
            if (request.getOffset() > 0) {
                query.setFirstResult(request.getOffset());
            }
            if (dataSet.getLimit() != null && dataSet.getLimit() > 0) {
                query.setMaxResults(dataSet.getLimit().intValue());
            }
            this.transformQueryResult(query);
            if (request.getData() != null) {
                QueryBinder.of(query).bind(context, new Object[0]);
            }
            data.put("dataset", query.getResultList());
        }
        return response;
    }

    private void transformQueryResult(Query query) {
        ((org.hibernate.query.Query)query.unwrap(org.hibernate.query.Query.class)).setResultTransformer((ResultTransformer)new DataSetTransformer());
    }

    private static final class DataSetTransformer
    extends BasicTransformerAdapter {
        private DataSetTransformer() {
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(tuple.length);
            for (int i = 0; i < tuple.length; ++i) {
                String alias = aliases[i];
                if (alias == null) continue;
                result.put(alias, tuple[i]);
            }
            return result;
        }
    }
}

