/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.web;

import com.axelor.app.AppSettings;
import com.axelor.common.StringUtils;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.i18n.I18n;
import com.axelor.i18n.I18nBundle;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaScanner;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.MetaTranslation;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.repo.MetaTranslationRepository;
import com.axelor.meta.loader.ModuleManager;
import com.axelor.meta.loader.XMLViews;
import com.axelor.meta.schema.ObjectViews;
import com.axelor.meta.schema.actions.Action;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.meta.service.MetaService;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaController {
    @Inject
    private ModuleManager moduleManager;
    @Inject
    private MetaTranslationRepository translations;
    private static final Logger log = LoggerFactory.getLogger(MetaController.class);
    private static final String DEFAULT_EXPORT_DIR = "{java.io.tmpdir}/axelor/data-export";
    private static final String EXPORT_DIR = AppSettings.get().getPath("data.export.dir", "{java.io.tmpdir}/axelor/data-export");

    private ObjectViews validateXML(String xml) {
        try {
            return XMLViews.fromXML(xml);
        }
        catch (JAXBException e) {
            String message = I18n.get("Invalid XML.");
            Throwable ex = e.getLinkedException();
            if (ex != null) {
                message = ex.getMessage().replaceFirst("[^:]+\\:(.*)", "$1");
            }
            throw new IllegalArgumentException(message);
        }
    }

    public void validateAction(ActionRequest request, ActionResponse response) {
        ObjectViews views;
        MetaAction meta = request.getContext().asType(MetaAction.class);
        Action action = XMLViews.findAction(meta.getName());
        HashMap data = Maps.newHashMap();
        response.setData(ImmutableList.of((Object)data));
        try {
            views = this.validateXML(meta.getXml());
        }
        catch (Exception e) {
            data.put("error", e.getMessage());
            return;
        }
        Action current = views.getActions().get(0);
        if (action != null && !action.getName().equals(current.getName())) {
            data.put("error", I18n.get("Action name can't be changed."));
            return;
        }
    }

    public void validateView(ActionRequest request, ActionResponse response) {
        MetaView meta = request.getContext().asType(MetaView.class);
        HashMap data = Maps.newHashMap();
        try {
            this.validateXML(meta.getXml());
        }
        catch (Exception e) {
            data.put("error", e.getMessage());
        }
        response.setData(ImmutableList.of((Object)data));
    }

    public void contextFieldChange(ActionRequest request, ActionResponse response) {
        Class<?> modelClass;
        MetaJsonField jsonField = request.getContext().asType(MetaJsonField.class);
        String modelName = jsonField.getModel();
        String fieldName = jsonField.getContextField();
        try {
            modelClass = Class.forName(modelName);
        }
        catch (ClassNotFoundException e) {
            response.setException(e);
            return;
        }
        Mapper mapper = Mapper.of(modelClass);
        Property property = mapper.getProperty(fieldName);
        String target = property == null ? null : property.getTarget().getName();
        String targetName = property == null ? null : property.getTargetName();
        response.setValue("contextFieldTarget", target);
        response.setValue("contextFieldTargetName", targetName);
        response.setValue("contextFieldValue", null);
        response.setValue("contextFieldTitle", null);
    }

    public void clearCache(ActionRequest request, ActionResponse response) {
        if (request.getBeanClass() != null && MetaView.class.isAssignableFrom(request.getBeanClass())) {
            MetaView view = request.getContext().asType(MetaView.class);
            int deleted = Beans.get(MetaService.class).removeCustomViews(view);
            if (deleted > 0) {
                response.setNotify(I18n.get("{0} customized view is deleted.", "{0} customized views are deleted.", deleted));
            }
        }
        MetaStore.clear();
    }

    public void openModel(ActionRequest request, ActionResponse response) {
        MetaField metaField = request.getContext().asType(MetaField.class);
        String domain = String.format("self.packageName = '%s' AND self.name = '%s'", metaField.getPackageName(), metaField.getTypeName());
        response.setView(ActionView.define(metaField.getTypeName()).model(MetaModel.class.getName()).domain(domain).map());
        response.setCanClose(true);
    }

    public void restoreAll(ActionRequest request, ActionResponse response) {
        try {
            Instant startInstant = Instant.now();
            this.moduleManager.restoreMeta();
            MetaStore.clear();
            I18nBundle.invalidate();
            Duration duration = Duration.between(startInstant, Instant.now());
            String durationTime = LocalTime.MIN.plusSeconds(duration.getSeconds()).format(DateTimeFormatter.ISO_LOCAL_TIME);
            response.setNotify(String.format(I18n.get("All views have been restored (%s)."), durationTime) + "<br>" + I18n.get("Please refresh your browser to see updated views."));
            log.info("Restore meta time: {}", (Object)durationTime);
        }
        catch (Exception e) {
            response.setException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportI18n(String module, URL file) throws IOException {
        String name = Paths.get(file.getFile(), new String[0]).getFileName().toString();
        if (!name.startsWith("messages_")) {
            return;
        }
        Path path = Paths.get(EXPORT_DIR, "i18n");
        String lang = name.substring(9, name.length() - 4);
        Path target = path.resolve(Paths.get(module, "src/main/resources/i18n", name));
        ArrayList<String[]> items = new ArrayList<String[]>();
        try (CSVReader reader = new CSVReader((Reader)new InputStreamReader(file.openStream()));){
            String[] header = reader.readNext();
            String[] values = null;
            while ((values = reader.readNext()) != null) {
                if (header.length != values.length) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                for (int i = 0; i < header.length; ++i) {
                    map.put(header[i], values[i]);
                }
                String key = (String)map.get("key");
                String value = (String)map.get("value");
                if (StringUtils.isBlank((CharSequence)key)) continue;
                MetaTranslation tr = this.translations.findByKey(key, lang);
                if (tr != null) {
                    value = tr.getMessage();
                }
                String[] row = new String[]{key, value, (String)map.get("comment"), (String)map.get("context")};
                items.add(row);
            }
        }
        Files.createParentDirs((File)target.toFile());
        try (CSVWriter writer = new CSVWriter((Writer)new FileWriter(target.toFile()));){
            writer.writeNext(new String[]{"key", "message", "comment", "context"});
            writer.writeAll(items);
        }
    }

    public void exportI18n(ActionRequest request, ActionResponse response) {
        for (String module : ModuleManager.getResolution()) {
            for (URL file : MetaScanner.findAll(module, "i18n", "(.*?)\\.csv")) {
                try {
                    this.exportI18n(module, file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        response.setFlash(I18n.get("Export complete."));
    }
}

