/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.web;

import com.axelor.i18n.I18n;
import com.axelor.meta.CallMethod;
import com.axelor.meta.db.MetaModule;
import com.axelor.meta.db.repo.MetaModuleRepository;
import com.axelor.meta.loader.ModuleManager;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Response;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.persist.Transactional;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ModuleController {
    private static final String messageRestart = I18n.get("Restart the server for updates to take effect.");
    private static final String alertInstall = I18n.get("Following modules will be installed : <p>%s</p> Are you sure ?");
    private static final String alertUninstall = I18n.get("Following modules will be uninstalled : <p>%s</p> Are you sure ?");
    private static final String errorDepends = I18n.get("The module can't be uninstalled because other non-removable modules depend on it.");
    private static final String errorPending = I18n.get("The module can't be uninstalled because other modules are pending. Please restart the server before.");
    @Inject
    private MetaModuleRepository modules;

    @Transactional
    protected void doInstall(String name) {
        MetaModule module = this.modules.findByName(name);
        if (module == null) {
            throw new IllegalArgumentException("No such module: " + name);
        }
        for (String dep : this.resolve(module)) {
            MetaModule mod = this.modules.findByName(dep);
            mod.setInstalled(true);
            mod.setPending(true);
        }
    }

    @Transactional
    protected void doUninstall(String name) {
        MetaModule module = this.modules.findByName(name);
        if (module == null) {
            throw new IllegalArgumentException("No such module: " + name);
        }
        for (String dep : this.resolveLink(module, this.getMainModule())) {
            MetaModule mod = this.modules.findByName(dep);
            mod.setInstalled(false);
            mod.setPending(true);
        }
    }

    private Set<String> resolve(MetaModule module) {
        HashSet<String> all = new HashSet<String>();
        Set<MetaModule> depends = module.getDepends();
        all.add(module.getName());
        if (depends == null || depends.isEmpty()) {
            return all;
        }
        depends.stream().filter(m -> m.getInstalled() != Boolean.TRUE).map(MetaModule::getName).forEach(all::add);
        return all;
    }

    private String getMainModule() {
        List<String> list = ModuleManager.getResolution();
        return list.get(list.size() - 1);
    }

    private Set<String> resolveLink(MetaModule module, String mainModule) {
        HashSet<String> all = new HashSet<String>();
        all.add(module.getName());
        for (MetaModule metaModule : this.modules.all().filter("?1 MEMBER OF self.depends", module.getId()).fetch()) {
            if (metaModule.getApplication() == Boolean.TRUE || metaModule.getInstalled() != Boolean.TRUE || mainModule.equals(metaModule.getName())) continue;
            if (metaModule.getPending() == Boolean.TRUE) {
                throw new IllegalArgumentException(errorPending);
            }
            if (metaModule.getRemovable() != Boolean.TRUE) {
                throw new IllegalArgumentException(errorDepends);
            }
            all.addAll(this.resolveLink(metaModule, mainModule));
        }
        return all;
    }

    @CallMethod
    public Response install(String name) {
        ActionResponse response = new ActionResponse();
        try {
            this.doInstall(name);
            response.setFlash(messageRestart);
            response.setReload(true);
        }
        catch (Exception e) {
            response.setException(e);
        }
        return response;
    }

    @CallMethod
    @Transactional
    public Response uninstall(String name) {
        ActionResponse response = new ActionResponse();
        try {
            this.doUninstall(name);
            response.setFlash(messageRestart);
            response.setReload(true);
        }
        catch (Exception e) {
            response.setException(e);
        }
        return response;
    }

    @CallMethod
    public Response validInstall(String name) {
        ActionResponse response = new ActionResponse();
        HashMap data = Maps.newHashMap();
        try {
            MetaModule module = this.modules.findByName(name);
            if (module == null) {
                throw new IllegalArgumentException("No such module: " + name);
            }
            String text = this.resolve(module).stream().map(n -> "<li>" + n + "</li>").collect(Collectors.joining());
            text = "<ul>" + text + "</ul>";
            data.put("alert", String.format(alertInstall, text));
            response.setData(ImmutableList.of((Object)data));
        }
        catch (Exception e) {
            response.setException(e);
        }
        return response;
    }

    @CallMethod
    public Response validUninstall(String name) {
        ActionResponse response = new ActionResponse();
        HashMap data = Maps.newHashMap();
        try {
            MetaModule module = this.modules.findByName(name);
            if (module == null) {
                throw new IllegalArgumentException("No such module: " + name);
            }
            String text = this.resolveLink(module, this.getMainModule()).stream().map(n -> "<li>" + n + "</li>").collect(Collectors.joining());
            text = "<ul>" + text + "</ul>";
            data.put("alert", String.format(alertUninstall, text));
            response.setData(ImmutableList.of((Object)data));
        }
        catch (Exception e) {
            response.setException(e);
        }
        return response;
    }
}

