/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.quartz;

import com.google.inject.servlet.RequestScoper;
import com.google.inject.servlet.ServletScopes;
import java.util.Collections;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.JobRunShell;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.spi.TriggerFiredBundle;

public class GuiceJobRunShell
extends JobRunShell {
    private QuartzScheduler sched;
    private QuartzSchedulerResources resources;

    public GuiceJobRunShell(Scheduler scheduler, TriggerFiredBundle bndle, QuartzSchedulerResources resources) {
        super(scheduler, bndle);
        this.resources = resources;
    }

    public void initialize(QuartzScheduler sched) throws SchedulerException {
        this.sched = sched;
    }

    public void run() {
        RequestScoper scope = ServletScopes.scopeRequest(Collections.emptyMap());
        try (RequestScoper.CloseableScope ignored = scope.open();){
            try {
                super.initialize(this.sched);
                super.run();
            }
            catch (SchedulerException e) {
                this.resources.getJobStore().triggeredJobComplete(this.firedTriggerBundle.getTrigger(), this.firedTriggerBundle.getJobDetail(), Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR);
            }
        }
    }
}

