/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.report;

import com.axelor.app.AppSettings;
import com.axelor.common.ResourceUtils;
import com.axelor.common.StringUtils;
import com.axelor.report.ReportResourceLocator;
import com.lowagie.text.FontFactory;
import java.io.File;
import java.net.MalformedURLException;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.model.api.IResourceLocator;

@Singleton
public class ReportEngineProvider
implements Provider<IReportEngine> {
    private IReportEngine engine;

    private IReportEngine init() {
        EngineConfig config = new EngineConfig();
        String fontConfig = AppSettings.get().getPath("reports.fonts.config", null);
        config.setResourceLocator((IResourceLocator)new ReportResourceLocator());
        if (StringUtils.notBlank((CharSequence)fontConfig)) {
            try {
                config.setFontConfig(new File(fontConfig).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        } else {
            config.setFontConfig(ResourceUtils.getResource((String)"/com/axelor/report/fonts/fontsConfig.xml"));
            FontFactory.register((String)"/com/axelor/report/fonts/dejavu/DejaVuSans.ttf");
            FontFactory.register((String)"/com/axelor/report/fonts/dejavu/DejaVuSans-Bold.ttf");
            FontFactory.register((String)"/com/axelor/report/fonts/dejavu/DejaVuSans-Oblique.ttf");
            FontFactory.register((String)"/com/axelor/report/fonts/dejavu/DejaVuSans-BoldOblique.ttf");
            FontFactory.register((String)"/com/axelor/report/fonts/dejavu/DejaVuSerif.ttf");
            FontFactory.register((String)"/com/axelor/report/fonts/dejavu/DejaVuSerif-Bold.ttf");
            FontFactory.register((String)"/com/axelor/report/fonts/dejavu/DejaVuSerif-Italic.ttf");
            FontFactory.register((String)"/com/axelor/report/fonts/dejavu/DejaVuSerif-BoldItalic.ttf");
            FontFactory.register((String)"/com/axelor/report/fonts/dejavu/DejaVuSans.ttf");
            FontFactory.register((String)"/com/axelor/report/fonts/dejavu/DejaVuSansMono-Bold.ttf");
            FontFactory.register((String)"/com/axelor/report/fonts/dejavu/DejaVuSansMono-Oblique.ttf");
            FontFactory.register((String)"/com/axelor/report/fonts/dejavu/DejaVuSansMono-BoldOblique.ttf");
        }
        return new ReportEngine(config);
    }

    public IReportEngine get() {
        if (this.engine == null) {
            this.engine = this.init();
        }
        return this.engine;
    }
}

