/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.report;

import com.axelor.app.internal.AppFilter;
import com.axelor.db.JPA;
import com.axelor.meta.MetaFiles;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.emitter.pdf.PDFPageDevice;
import org.eclipse.birt.report.model.api.IResourceLocator;

public class ReportGenerator {
    @Inject
    private IReportEngine engine;

    public void generate(OutputStream output, String designName, String format, Map<String, Object> params) throws IOException, BirtException {
        this.generate(output, designName, format, params, AppFilter.getLocale());
    }

    public void generate(OutputStream output, String designName, String format, Map<String, Object> params, Locale locale) throws IOException, BirtException {
        IResourceLocator locator = this.engine.getConfig().getResourceLocator();
        URL found = locator.findResource(null, designName, 0);
        if (found == null) {
            throw new BirtException("No such report found: " + designName);
        }
        try (InputStream stream = found.openStream();){
            IReportRunnable report = this.engine.openReportDesign(designName, stream);
            final IRunAndRenderTask task = this.engine.createRunAndRenderTask(report);
            RenderOption opts = new RenderOption();
            opts.setOutputFormat(format);
            opts.setOutputStream(output);
            if ("pdf".equals(format)) {
                opts.setOption("pdfRenderOption.hyphenation", (Object)true);
            }
            task.setLocale(locale);
            task.setRenderOption((IRenderOption)opts);
            task.setParameterValues(params);
            task.getAppContext().put("PARENT_CLASSLOADER", this.getClass().getClassLoader());
            task.getAppContext().put("OdaJDBCDriverPassInConnectionCloseAfterUse", Boolean.FALSE);
            JPA.jdbcWork(new JPA.JDBCWork(){

                @Override
                public void execute(Connection connection) throws SQLException {
                    task.getAppContext().put("OdaJDBCDriverPassInConnection", connection);
                    try {
                        task.run();
                    }
                    catch (EngineException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        task.close();
                    }
                }
            });
        }
    }

    public File generate(String designName, String format, Map<String, Object> params) throws IOException, BirtException {
        return this.generate(designName, format, params, AppFilter.getLocale());
    }

    public File generate(String designName, String format, Map<String, Object> params, Locale locale) throws IOException, BirtException {
        Preconditions.checkNotNull((Object)designName, (Object)"no report design name given");
        Path tmpFile = MetaFiles.createTempFile(null, "", new FileAttribute[0]);
        try (FileOutputStream stream = new FileOutputStream(tmpFile.toFile());){
            this.generate(stream, designName, format, params, locale);
        }
        return tmpFile.toFile();
    }

    static {
        try {
            Pattern p;
            Matcher m;
            Field field = PDFPageDevice.class.getDeclaredField("versionInfo");
            field.setAccessible(true);
            String[] info = (String[])field.get(PDFPageDevice.class);
            String version = info[0];
            if (version.endsWith(".jar") && (m = (p = Pattern.compile(".*?\\-([^-]+)\\.jar")).matcher(version)).matches()) {
                info[0] = m.group(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

