/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.report;

import com.axelor.app.AppSettings;
import com.axelor.common.FileUtils;
import com.axelor.common.ResourceUtils;
import com.axelor.db.internal.DBHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportResourceLocator
implements IResourceLocator {
    public static final String DEFAULT_REPORT_DIR = "{user.home}/axelor/reports";
    private static final Pattern URL_PATTERN = Pattern.compile("^(file|jar|http|https|ftp):/.*");
    private static final Logger log = LoggerFactory.getLogger(ReportResourceLocator.class);
    private Path searchPath;

    public ReportResourceLocator() {
        if (AppSettings.get().getProperties().containsKey("axelor.report.dir")) {
            log.warn("configuration '{}' is deprecated, please use '{}'", (Object)"axelor.report.dir", (Object)"reports.design.dir");
        }
        String dir = AppSettings.get().getPath("reports.design.dir", AppSettings.get().getPath("axelor.report.dir", DEFAULT_REPORT_DIR));
        this.searchPath = Paths.get(dir, new String[0]);
    }

    public URL findResource(ModuleHandle moduleHandle, String fileName, int type, Map appContext) {
        return this.findResource(moduleHandle, fileName, type);
    }

    public URL findResource(ModuleHandle moduleHandle, String fileName, int type) {
        URL found;
        if (DBHelper.isOracle() && fileName.endsWith(".rptlibrary") && (found = this.find(moduleHandle, fileName.replace(".rptlibrary", ".oracle.rptlibrary"), type)) != null) {
            return found;
        }
        return this.find(moduleHandle, fileName, type);
    }

    private URL find(ModuleHandle moduleHandle, String fileName, int type) {
        URL url;
        File found;
        String subDir;
        switch (type) {
            case 2: {
                subDir = "lib";
                break;
            }
            case 1: {
                subDir = "img";
                break;
            }
            case 3: {
                subDir = "css";
                break;
            }
            default: {
                subDir = ".";
            }
        }
        if (URL_PATTERN.matcher(fileName).matches()) {
            try {
                return new URL(fileName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (!(found = new File(fileName)).exists()) {
            found = this.searchPath.resolve(fileName).toFile();
        }
        if (!found.exists()) {
            found = this.searchPath.resolve(subDir).normalize().resolve(fileName).toFile();
        }
        if (found.exists()) {
            try {
                return found.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((url = ResourceUtils.getResource((String)FileUtils.getFile((String)"reports", (String[])new String[]{fileName}).getPath().replace("\\", "/"))) == null) {
            url = ResourceUtils.getResource((String)FileUtils.getFile((String)"reports", (String[])new String[]{subDir, fileName}).getPath().replace("\\", "/"));
        }
        return url;
    }
}

