/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.rpc.ContextEntity;
import com.axelor.rpc.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType
@XmlRootElement(name="response")
public class ActionResponse
extends Response {
    private Map<String, Object> dataMap;
    private static final Logger log = LoggerFactory.getLogger(ActionResponse.class);

    private Map<String, Object> dataMap() {
        if (this.dataMap == null) {
            this.dataMap = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            data.add(this.dataMap);
            this.setData(data);
        }
        return this.dataMap;
    }

    private void set(String name, Object value) {
        this.dataMap().put(name, value);
    }

    public void setReload(boolean reload) {
        this.set("reload", reload);
    }

    public void setCanClose(boolean canClose) {
        this.set("canClose", canClose);
    }

    public void setFlash(String flash) {
        this.set("flash", flash);
    }

    public void setNotify(String message) {
        this.set("notify", message);
    }

    public void setAlert(String message) {
        this.set("alert", message);
    }

    public void setError(String message) {
        this.set("error", message);
    }

    public void setPending(String actions) {
        this.set("pending", actions);
    }

    public void setExportFile(String path) {
        this.set("exportFile", path);
    }

    public void setValues(Object context) {
        boolean managed = false;
        if (context instanceof ContextEntity || context instanceof Map || (managed = context instanceof Model && JPA.em().contains(context))) {
            if (managed) {
                log.warn("managed instance passed as context: {}#{}", EntityHelper.getEntityClass(context), (Object)((Model)context).getId());
            }
        } else {
            throw new IllegalArgumentException("Invalid context object.");
        }
        this.set("values", context);
    }

    public void setValue(String fieldName, Object value) {
        HashMap<String, Object> values = (HashMap<String, Object>)this.dataMap().get("values");
        if (values == null) {
            values = new HashMap<String, Object>();
            this.setValues(values);
        }
        values.put(fieldName, value);
    }

    public void setView(Map<String, Object> view) {
        this.set("view", view);
    }

    public void setView(String title, String model, String mode, String domain) {
        HashMap<String, Object> view = new HashMap<String, Object>();
        view.put("title", title);
        view.put("model", model);
        view.put("type", mode);
        view.put("domain", domain);
        this.setView(view);
    }

    public void setSignal(String signal, Object data) {
        this.set("signal", signal);
        this.set("signal-data", data);
    }

    public void setAttrs(Map<String, Map<String, Object>> attrs) {
        this.set("attrs", attrs);
    }

    public void setAttr(String fieldName, String attr, Object value) {
        HashMap<String, Object> my;
        HashMap<String, Map<String, Object>> attrs = null;
        try {
            attrs = (Map)((Map)this.getItem(0)).get("attrs");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (attrs == null) {
            attrs = new HashMap<String, Map<String, Object>>();
        }
        if ((my = (HashMap<String, Object>)attrs.get(fieldName)) == null) {
            my = new HashMap<String, Object>();
        }
        my.put(attr, value);
        attrs.put(fieldName, my);
        this.setAttrs(attrs);
    }

    public void setRequired(String fieldName, boolean required) {
        this.setAttr(fieldName, "required", required);
    }

    public void setReadonly(String fieldName, boolean readonly) {
        this.setAttr(fieldName, "readonly", readonly);
    }

    public void setHidden(String fieldName, boolean hidden) {
        this.setAttr(fieldName, "hidden", hidden);
    }

    public void setColor(String fieldName, String color) {
        this.setAttr(fieldName, "color", color);
    }
}

