/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.common.StringUtils;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.rpc.ContextHandler;
import com.axelor.rpc.ContextHandlerFactory;
import com.axelor.rpc.JsonContext;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.script.SimpleBindings;

@JsonSerialize(using=Serializer.class)
public class Context
extends SimpleBindings {
    private static final String KEY_MODEL = "_model";
    private static final String KEY_PARENT = "_parent";
    private static final String KEY_PARENT_CONTEXT = "parentContext";
    static final String KEY_ID = "id";
    static final String KEY_JSON_ATTRS = "attrs";
    static final String KEY_JSON_MODEL = "jsonModel";
    static final String KEY_JSON_PREFIX = "$";
    private final Map<String, Object> values;
    private final Mapper mapper;
    private final Class<?> beanClass;
    private ContextHandler<?> handler;
    private Context parent;
    private Map<String, Object> jsonFields;

    public Context(Map<String, Object> values, Class<?> beanClass) {
        super(values);
        this.values = Objects.requireNonNull(values);
        this.beanClass = Objects.requireNonNull(beanClass);
        this.mapper = Mapper.of(beanClass);
    }

    public Context(Class<?> beanClass) {
        this(new HashMap<String, Object>(), beanClass);
    }

    public Context(Long id, Class<?> beanClass) {
        this(beanClass);
        this.values.put(KEY_ID, id);
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.getContextHandler().addChangeListener(listener);
    }

    private Map<String, Object> jsonFields() {
        if (this.jsonFields == null) {
            this.jsonFields = MetaJsonRecord.class.isAssignableFrom(this.beanClass) ? MetaStore.findJsonFields((String)this.values.get(KEY_JSON_MODEL)) : MetaStore.findJsonFields(this.beanClass.getName(), KEY_JSON_ATTRS);
        }
        return this.jsonFields;
    }

    private ContextHandler<?> getContextHandler() {
        if (this.handler == null) {
            this.handler = ContextHandlerFactory.newHandler(this.beanClass, this.values);
        }
        return this.handler;
    }

    private Object getProxy() {
        return this.getContextHandler().getProxy();
    }

    public Context getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        Object value = this.values.get(KEY_PARENT);
        if (value == null) {
            return null;
        }
        try {
            Map valueMap = (Map)value;
            Class<?> parentClass = Class.forName((String)valueMap.get(KEY_MODEL));
            this.parent = new Context(valueMap, parentClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.parent;
    }

    @Deprecated
    public Context getParentContext() {
        return this.getParent();
    }

    public Class<?> getContextClass() {
        return this.beanClass;
    }

    public <T> T asType(Class<T> type) {
        Object bean = this.getProxy();
        if (!type.isInstance(bean)) {
            throw new IllegalArgumentException(String.format("Invalid type %s, should be %s", type.getName(), this.beanClass.getName()));
        }
        return (T)bean;
    }

    private String checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("key should be a String");
        }
        if (StringUtils.isEmpty((CharSequence)((String)key))) {
            throw new IllegalArgumentException("key can not be empty");
        }
        return (String)key;
    }

    private boolean isJsonName(String name) {
        return this.isJsonRecord() && "name".equals(name);
    }

    private boolean isJsonRecord() {
        return MetaJsonRecord.class.isAssignableFrom(this.getContextClass());
    }

    private boolean hasJsonField(String name) {
        return !KEY_JSON_MODEL.equals(name) && !KEY_JSON_ATTRS.equals(name) && this.jsonFields() != null && this.jsonFields().containsKey(name);
    }

    private boolean isJsonField(String name) {
        return name.startsWith(KEY_JSON_PREFIX) && this.mapper.getProperty(name.substring(KEY_JSON_PREFIX.length())) != null && this.mapper.getProperty(name.substring(KEY_JSON_PREFIX.length())).isJson();
    }

    private JsonContext getJsonContext(Property property, Object value) {
        String name = property.getName();
        return (JsonContext)this.values.computeIfAbsent(KEY_JSON_PREFIX + name, k -> new JsonContext(this, property, (String)value));
    }

    private JsonContext getJsonContext() {
        Property property = this.mapper.getProperty(KEY_JSON_ATTRS);
        return this.getJsonContext(property, property.get(this.getProxy()));
    }

    private Object tryJsonGet(String name) {
        if (this.hasJsonField(name)) {
            return this.getJsonContext().get(name);
        }
        return super.get(name);
    }

    private Object tryJsonPut(String name, Object value) {
        if (this.hasJsonField(name)) {
            return this.getJsonContext().put(name, value);
        }
        return super.put(name, value);
    }

    @Override
    public boolean containsKey(Object key) {
        String name = this.checkKey(key);
        return super.containsKey(name) || KEY_PARENT_CONTEXT.equals(name) || this.isJsonField(name) || this.hasJsonField(name) || this.mapper.getProperty((String)key) != null;
    }

    @Override
    public Object get(Object key) {
        this.checkKey(key);
        if (KEY_PARENT_CONTEXT.equals(key)) {
            return this.getParent();
        }
        String name = (String)key;
        Object value = super.get(name);
        if (value instanceof JsonContext) {
            return value;
        }
        Property property = this.mapper.getProperty(name);
        if (property != null && !this.isJsonName(name)) {
            return property.get(this.getProxy());
        }
        if (this.isJsonField(name)) {
            Property jsonProperty = this.mapper.getProperty(name.substring(KEY_JSON_PREFIX.length()));
            return this.getJsonContext(jsonProperty, jsonProperty.get(this.getProxy()));
        }
        return this.tryJsonGet((String)key);
    }

    @Override
    public Object put(String name, Object value) {
        if (this.mapper.getSetter(name) == null || this.isJsonRecord() && this.hasJsonField(name)) {
            if (this.isJsonName(name)) {
                this.mapper.set(this.getProxy(), name, value);
            }
            return this.tryJsonPut(name, value);
        }
        return this.mapper.set(this.getProxy(), name, this.handler.validate(this.mapper.getProperty(name), value));
    }

    static class Serializer
    extends JsonSerializer<Context> {
        Serializer() {
        }

        public void serialize(Context value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                JsonSerializer serializer = provider.findValueSerializer(Map.class, null);
                HashMap map = new HashMap();
                value.entrySet().stream().filter(e -> !(e.getValue() instanceof JsonContext)).filter(e -> !Context.KEY_PARENT_CONTEXT.equals(e.getKey())).forEach(e -> map.put(e.getKey(), e.getValue()));
                serializer.serialize(map, jgen, provider);
            }
        }
    }
}

