/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.common.ObjectUtils;
import com.axelor.rpc.Request;
import com.axelor.rpc.Response;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

public class RequestUtils {
    private RequestUtils() {
    }

    public static void processRequest(Request request, Consumer<Map<String, Object>> consumer) {
        Collection<Object> records = RequestUtils.getRecords(request.getRecords(), request.getData());
        RequestUtils.processRecords(records, consumer);
    }

    public static void processResponse(Response response, Consumer<Map<String, Object>> consumer) {
        Collection<Object> records = RequestUtils.getRecords(Collections.emptyList(), response.getData());
        RequestUtils.processRecords(records, consumer);
    }

    private static Collection<Object> getRecords(Collection<Object> records, Object data) {
        Collection dataAsCollection;
        Object allRecords = ObjectUtils.notEmpty(records) ? records : (data instanceof Collection ? (dataAsCollection = (Collection)data) : (data != null ? ImmutableList.of((Object)data) : Collections.emptyList()));
        return allRecords;
    }

    private static void processRecords(Collection<Object> records, Consumer<Map<String, Object>> consumer) {
        records.stream().filter(record -> record instanceof Map).forEach(record -> {
            Map values = (Map)record;
            consumer.accept(values);
        });
    }
}

