/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc;

import com.axelor.common.StringUtils;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.i18n.I18n;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class Translator {
    private Translator() {
    }

    private static String getTranslation(String value) {
        String key;
        String val;
        if (StringUtils.notBlank((CharSequence)value) && !Objects.equals(val = I18n.get(key = Translator.toValueKey(value)), key)) {
            return val;
        }
        return value;
    }

    private static String toValueKey(String name) {
        return "value:" + name;
    }

    private static String toKey(String name) {
        return "$t:" + name;
    }

    @Nullable
    private static Property getProperty(Mapper mapper, String field) {
        Property property = null;
        Iterator names = Arrays.stream(field.split("\\.")).iterator();
        while (names.hasNext()) {
            property = mapper.getProperty((String)names.next());
            if (property == null) {
                return null;
            }
            if (!names.hasNext()) continue;
            if (property.getTarget() == null) {
                return null;
            }
            mapper = Mapper.of(property.getTarget());
        }
        return property;
    }

    static Map<String, Object> translate(Map<String, Object> values, Property property) {
        return Translator.translate(values, property.getName());
    }

    static Map<String, Object> translate(Map<String, Object> values, String name) {
        String val;
        Object value = values.get(name);
        if (value instanceof String && !Objects.equals(val = Translator.getTranslation((String)value), value)) {
            values.put(Translator.toKey(name), val);
        }
        return values;
    }

    static void applyTranslatables(Map<String, Object> values, Class<?> model) {
        Mapper mapper = Mapper.of(model);
        Collection names = values.keySet().stream().collect(Collectors.toList());
        names.forEach(name -> {
            Property property;
            Object value = values.get(name);
            if (value instanceof String) {
                Property property2 = Translator.getProperty(mapper, name);
                if (property2 != null && property2.isTranslatable()) {
                    Translator.translate(values, name);
                }
            } else if (value instanceof Map && (property = Translator.getProperty(mapper, name)) != null && property.getTarget() != null) {
                Map map = (Map)value;
                Translator.applyTranslatables(map, property.getTarget());
            }
        });
    }
}

