/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.rpc.filter;

import com.axelor.common.StringUtils;
import com.axelor.rpc.filter.Filter;
import com.axelor.rpc.filter.Operator;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class LogicalFilter
extends Filter {
    private Operator operator;
    private List<Filter> filters;

    public LogicalFilter(Operator operator, List<Filter> filters) {
        this.operator = operator;
        this.filters = filters;
    }

    @Override
    public String getQuery() {
        if (this.filters == null || this.filters.isEmpty()) {
            return "";
        }
        List filterParts = this.filters.stream().map(Filter::toString).filter(StringUtils::notBlank).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        if (this.operator == Operator.NOT) {
            sb.append("NOT ");
        }
        if (filterParts.size() > 1) {
            sb.append("(");
        }
        String joiner = this.operator == Operator.NOT ? " AND " : " " + this.operator.name() + " ";
        sb.append(Joiner.on((String)joiner).join(filterParts));
        if (filterParts.size() > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public List<Object> getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Filter filter : this.filters) {
            params.addAll(filter.getParams());
        }
        return params;
    }
}

