/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.script;

import com.axelor.common.StringUtils;
import com.axelor.script.ScriptHelper;
import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScriptHelper
implements ScriptHelper {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Bindings bindings;

    @Override
    public Bindings getBindings() {
        return this.bindings;
    }

    @Override
    public void setBindings(Bindings bindings) {
        this.bindings = bindings;
    }

    @Override
    public final boolean test(String expr) {
        if (StringUtils.isBlank((CharSequence)expr)) {
            return true;
        }
        Object result = this.eval(expr);
        if (result == null) {
            return false;
        }
        if (result instanceof Number && result.equals(0)) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return true;
    }

    @Override
    public Object call(Object obj, String methodCall) {
        Preconditions.checkNotNull((Object)obj);
        Preconditions.checkNotNull((Object)methodCall);
        Pattern p = Pattern.compile("(\\w+)\\((.*?)\\)");
        Matcher m = p.matcher(methodCall);
        if (!m.matches()) {
            return null;
        }
        return this.doCall(obj, methodCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doCall(Object obj, String methodCall) {
        String key = "__obj__" + Math.abs(UUID.randomUUID().getMostSignificantBits());
        Bindings bindings = this.getBindings();
        try {
            bindings.put(key, obj);
            Object object = this.eval(key + "." + methodCall);
            return object;
        }
        finally {
            bindings.remove(key);
        }
    }

    @Override
    public Object eval(String expr) {
        try {
            return this.eval(expr, this.getBindings());
        }
        catch (NoSuchFieldException e) {
            this.log.warn("No such field in: {} -- ({})", (Object)expr, (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            if (e.getCause() instanceof NoSuchFieldException) {
                this.log.warn("No such field in: {} -- ({})", (Object)expr, (Object)e.getMessage());
                return null;
            }
            this.log.error("Script error: {}", (Object)expr, (Object)e);
            throw new IllegalArgumentException(e);
        }
    }
}

